/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.parser;

import io.hyperfoil.api.config.PhaseBuilder;
import io.hyperfoil.api.config.PhaseForkBuilder;
import io.hyperfoil.api.config.ScenarioBuilder;
import io.hyperfoil.core.parser.AbstractMappingParser;
import io.hyperfoil.core.parser.Adapter;
import io.hyperfoil.core.parser.Context;
import io.hyperfoil.core.parser.Parser;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.core.parser.PropertyParser;
import io.hyperfoil.core.parser.ScenarioParser;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;

class PhaseForkParser
implements Parser<PhaseBuilder<?>> {
    PhaseForkParser() {
    }

    @Override
    public void parse(Context ctx, PhaseBuilder<?> target) throws ParserException {
        Event event = ctx.peek();
        if (event instanceof SequenceStartEvent) {
            ctx.parseList(target, this::parseFork);
        } else if (event instanceof MappingStartEvent) {
            ctx.parseMapping(target, ForkBuilderParser::new);
        }
    }

    private void parseFork(Context ctx, PhaseBuilder<?> phaseBuilder) throws ParserException {
        ctx.expectEvent(MappingStartEvent.class);
        ScalarEvent forkNameEvent = ctx.expectEvent(ScalarEvent.class);
        PhaseForkBuilder forkBuilder = phaseBuilder.fork(forkNameEvent.getValue());
        ForkParser.INSTANCE.parse(ctx, forkBuilder);
        ctx.expectEvent(MappingEndEvent.class);
    }

    static class ForkParser
    extends AbstractMappingParser<PhaseForkBuilder> {
        private static final ForkParser INSTANCE = new ForkParser();

        ForkParser() {
            this.register("weight", new PropertyParser.Double<PhaseForkBuilder>(PhaseForkBuilder::weight));
            this.register("scenario", new Adapter<PhaseForkBuilder, ScenarioBuilder>(PhaseForkBuilder::scenario, new ScenarioParser()));
        }
    }

    static class ForkBuilderParser
    implements Parser<PhaseBuilder<?>> {
        private final ScalarEvent forkNameEvent;

        ForkBuilderParser(ScalarEvent forkNameEvent) {
            this.forkNameEvent = forkNameEvent;
        }

        @Override
        public void parse(Context ctx, PhaseBuilder<?> target) throws ParserException {
            PhaseForkBuilder forkBuilder = target.fork(this.forkNameEvent.getValue());
            ForkParser.INSTANCE.parse(ctx, forkBuilder);
        }
    }
}

