/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.parser;

import io.hyperfoil.api.config.BenchmarkSource;
import io.hyperfoil.api.config.Locator;
import org.yaml.snakeyaml.events.Event;

public class ParserException
extends Exception {
    public ParserException(String msg) {
        this(msg, null);
    }

    public ParserException(String msg, Exception e) {
        super((String)(Locator.isAvailable() ? Locator.current().locationMessage() + ": " + msg : msg), e);
    }

    public ParserException(Event event, String msg) {
        this(event, msg, null);
    }

    public ParserException(Event event, String msg, Throwable cause) {
        super(ParserException.location(event, msg), cause);
    }

    static String location(Event event, String msg) {
        StringBuilder lineInfo = ParserException.location(event);
        lineInfo.append(": ").append(msg);
        String source = null;
        if (Locator.isAvailable()) {
            BenchmarkSource bs = Locator.current().benchmark().source();
            String string = source = bs == null ? null : bs.yaml;
        }
        if (source != null) {
            int min;
            int i;
            lineInfo.append("; See below: \n");
            String[] lines = source.split("\n");
            int current = event.getStartMark().getLine() + 1;
            for (i = min = Math.max(1, current - 2); i <= current; ++i) {
                lineInfo.append(lines[i - 1]).append('\n');
            }
            for (i = event.getStartMark().getColumn(); i > 0; --i) {
                lineInfo.append(' ');
            }
            lineInfo.append("^ HERE\n");
            for (i = 0; i < 2; ++i) {
                lineInfo.append(lines[current + i]).append('\n');
            }
        }
        return lineInfo.toString();
    }

    static StringBuilder location(Event event) {
        StringBuilder lineInfo = new StringBuilder("line ").append(event.getStartMark().getLine() + 1).append(", column ").append(event.getStartMark().getColumn() + 1);
        if (Locator.isAvailable()) {
            lineInfo.append(": ").append(Locator.current().locationMessage());
        }
        return lineInfo;
    }
}

