/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.parser;

import io.hyperfoil.api.config.BenchmarkBuilder;
import io.hyperfoil.api.config.PluginBuilder;
import io.hyperfoil.core.api.Plugin;
import io.hyperfoil.core.parser.Context;
import io.hyperfoil.core.parser.Parser;
import io.hyperfoil.core.parser.ParserException;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import org.yaml.snakeyaml.events.Event;

public class ErgonomicsParser
implements Parser<BenchmarkBuilder> {
    private final Map<String, PluginTuple<?, ?>> subParsers = new HashMap();

    ErgonomicsParser() {
        ServiceLoader.load(Plugin.class).forEach(factory -> factory.enhanceErgonomics(this));
    }

    @Override
    public void parse(Context ctx, BenchmarkBuilder target) throws ParserException {
        ctx.parseMapping(target, event -> {
            PluginTuple<?, ?> tuple = this.subParsers.get(event.getValue());
            if (tuple == null) {
                throw new ParserException((Event)event, "Invalid configuration label: '" + event.getValue() + "', expected one of " + String.valueOf(this.subParsers.keySet()));
            }
            return tuple;
        });
    }

    public <T extends PluginBuilder<E>, E> void register(String name, Class<T> plugin, Parser<E> parser) {
        PluginTuple<T, E> prev = this.subParsers.putIfAbsent(name, new PluginTuple<T, E>(plugin, parser));
        if (prev != null) {
            throw new IllegalStateException("Ergonomics property '" + name + "' already registered by " + prev.plugin.getName() + ", now trying to register by " + plugin.getName());
        }
    }

    private static class PluginTuple<T extends PluginBuilder<E>, E>
    implements Parser<BenchmarkBuilder> {
        final Class<T> plugin;
        final Parser<E> parser;

        private PluginTuple(Class<T> plugin, Parser<E> parser) {
            this.plugin = plugin;
            this.parser = parser;
        }

        @Override
        public void parse(Context ctx, BenchmarkBuilder target) throws ParserException {
            Object ergonomics = target.plugin(this.plugin).ergonomics();
            this.parser.parse(ctx, ergonomics);
        }
    }
}

