/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.parser;

import java.util.Iterator;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;

class DebugIterator<T>
implements Iterator<T> {
    private final Iterator<T> it;
    private String indent = "";

    DebugIterator(Iterator<T> it) {
        this.it = it;
    }

    @Override
    public boolean hasNext() {
        return this.it.hasNext();
    }

    @Override
    public T next() {
        T event = this.it.next();
        if (event instanceof MappingEndEvent || event instanceof SequenceEndEvent) {
            this.indent = this.indent.substring(2);
        }
        StackTraceElement[] stackTrace = new Exception().fillInStackTrace().getStackTrace();
        System.out.println(this.indent + String.valueOf(event) + " fetched from " + String.valueOf(stackTrace[1]) + "\t" + String.valueOf(stackTrace[2]) + "\t" + String.valueOf(stackTrace[3]));
        if (event instanceof MappingStartEvent || event instanceof SequenceStartEvent) {
            this.indent = this.indent + "| ";
        }
        return event;
    }
}

