/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.parser;

import io.hyperfoil.api.config.BenchmarkBuilder;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.core.parser.Context;
import io.hyperfoil.core.parser.Parser;
import io.hyperfoil.core.parser.ParserException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingEndEvent;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceEndEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;

class AgentsParser
implements Parser<BenchmarkBuilder> {
    private static final String DEFAULT = "default";

    AgentsParser() {
    }

    @Override
    public void parse(Context ctx, BenchmarkBuilder builder) throws ParserException {
        Event event = ctx.next();
        if (event instanceof ScalarEvent) {
            String value = ((ScalarEvent)event).getValue();
            if (value != null && !value.isEmpty()) {
                this.addAgent(builder, value, Collections.emptyMap());
            }
        } else if (event instanceof SequenceStartEvent) {
            Event next;
            while (ctx.hasNext() && !((next = ctx.next()) instanceof SequenceEndEvent)) {
                if (next instanceof ScalarEvent) {
                    this.parseAgent(ctx, builder, ((ScalarEvent)next).getValue());
                    continue;
                }
                if (next instanceof MappingStartEvent) {
                    ScalarEvent nameEvent = ctx.expectEvent(ScalarEvent.class);
                    this.parseAgent(ctx, builder, nameEvent.getValue());
                    ctx.expectEvent(MappingEndEvent.class);
                    continue;
                }
                throw ctx.unexpectedEvent(next);
            }
        } else if (event instanceof MappingStartEvent) {
            Event next;
            while (ctx.hasNext() && !((next = ctx.next()) instanceof MappingEndEvent)) {
                if (next instanceof ScalarEvent) {
                    this.parseAgent(ctx, builder, ((ScalarEvent)next).getValue());
                    continue;
                }
                throw ctx.unexpectedEvent(next);
            }
        } else {
            throw ctx.unexpectedEvent(event);
        }
    }

    private void parseAgent(Context ctx, BenchmarkBuilder builder, String name) throws ParserException {
        if (!ctx.hasNext()) {
            this.addAgent(builder, name, null);
            return;
        }
        Event next = ctx.peek();
        if (next instanceof ScalarEvent) {
            if (DEFAULT.equals(name)) {
                throw new BenchmarkDefinitionException("Agent defaults must be set as properties, not using the inline form.");
            }
            builder.addAgent(name, ctx.expectEvent(ScalarEvent.class).getValue(), Collections.emptyMap());
        } else if (next instanceof MappingStartEvent) {
            Event event;
            ctx.expectEvent(MappingStartEvent.class);
            HashMap<String, String> properties = new HashMap<String, String>();
            while (ctx.hasNext() && !((event = ctx.next()) instanceof MappingEndEvent)) {
                if (event instanceof ScalarEvent) {
                    String propertyName = ((ScalarEvent)event).getValue();
                    String propertyValue = ctx.expectEvent(ScalarEvent.class).getValue();
                    properties.put(propertyName, propertyValue);
                    continue;
                }
                throw ctx.unexpectedEvent(event);
            }
            this.addAgent(builder, name, properties);
        } else {
            this.addAgent(builder, name, Collections.emptyMap());
        }
    }

    private void addAgent(BenchmarkBuilder builder, String name, Map<String, String> properties) {
        if (DEFAULT.equals(name)) {
            builder.setDefaultAgentProperties(properties);
        } else {
            builder.addAgent(name, null, properties);
        }
    }
}

