/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.impl.rate;

import io.hyperfoil.core.impl.rate.ConstantRateGenerator;
import io.hyperfoil.core.impl.rate.FireTimeListener;
import io.hyperfoil.core.impl.rate.PoissonConstantRateGenerator;
import io.hyperfoil.core.impl.rate.PoissonRampRateGenerator;
import io.hyperfoil.core.impl.rate.RampRateGenerator;
import java.util.Random;

public interface RateGenerator {
    public long computeNextFireTime(long var1, FireTimeListener var3);

    public long lastComputedFireTimeMs();

    public long fireTimes();

    public static RateGenerator constantRate(double fireTimesPerSec) {
        return new ConstantRateGenerator(fireTimesPerSec);
    }

    public static RateGenerator rampRate(double initialFireTimesPerSec, double targetFireTimesPerSec, long durationMs) {
        if (Math.abs(targetFireTimesPerSec - initialFireTimesPerSec) < 1.0E-6) {
            return RateGenerator.constantRate(initialFireTimesPerSec);
        }
        return new RampRateGenerator(initialFireTimesPerSec, targetFireTimesPerSec, durationMs);
    }

    public static RateGenerator poissonConstantRate(Random random, double usersPerSec) {
        return new PoissonConstantRateGenerator(random, usersPerSec);
    }

    public static RateGenerator poissonConstantRate(double usersPerSec) {
        return RateGenerator.poissonConstantRate(new Random(), usersPerSec);
    }

    public static RateGenerator poissonRampRate(Random random, double initialFireTimesPerSec, double targetFireTimesPerSec, long durationMs) {
        if (Math.abs(targetFireTimesPerSec - initialFireTimesPerSec) < 1.0E-6) {
            return RateGenerator.poissonConstantRate(random, initialFireTimesPerSec);
        }
        return new PoissonRampRateGenerator(random, initialFireTimesPerSec, targetFireTimesPerSec, durationMs);
    }

    public static RateGenerator poissonRampRate(double initialFireTimesPerSec, double targetFireTimesPerSec, long durationMs) {
        return RateGenerator.poissonRampRate(new Random(), initialFireTimesPerSec, targetFireTimesPerSec, durationMs);
    }
}

