/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.impl.rate;

import io.hyperfoil.core.impl.rate.FunctionalRateGenerator;

final class RampRateGenerator
extends FunctionalRateGenerator {
    private final double bCoef;
    private final double progress;

    RampRateGenerator(double initialFireTimesPerSec, double targetFireTimesPerSec, long durationMs) {
        this.bCoef = initialFireTimesPerSec / 1000.0;
        this.progress = (targetFireTimesPerSec - initialFireTimesPerSec) / (double)(durationMs * 1000L);
    }

    @Override
    protected long computeFireTimes(long elapsedTimeMs) {
        return (long)((this.progress * (double)elapsedTimeMs / 2.0 + this.bCoef) * (double)elapsedTimeMs);
    }

    @Override
    protected double computeFireTimeMs(long targetFireTimes) {
        return Math.ceil((-this.bCoef + Math.sqrt(this.bCoef * this.bCoef + 2.0 * this.progress * (double)targetFireTimes)) / this.progress);
    }
}

