/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.impl.rate;

import io.hyperfoil.core.impl.rate.SequentialRateGenerator;
import java.util.Random;

final class PoissonRampRateGenerator
extends SequentialRateGenerator {
    private final double initialFireTimesPerSec;
    private final Random random;
    private final long duration;
    private final double aCoef;

    PoissonRampRateGenerator(Random random, double initialFireTimesPerSec, double targetFireTimesPerSec, long durationMs) {
        this.initialFireTimesPerSec = initialFireTimesPerSec;
        this.duration = durationMs;
        this.aCoef = targetFireTimesPerSec - initialFireTimesPerSec;
        this.random = random;
        this.fireTimeMs = this.nextFireTimeMs(0.0);
    }

    @Override
    protected double nextFireTimeMs(double elapsedTimeMs) {
        double bCoef = elapsedTimeMs * this.aCoef + this.initialFireTimesPerSec * (double)this.duration;
        double cCoef = (double)(this.duration * 1000L) * Math.log(this.random.nextDouble());
        return elapsedTimeMs + (-bCoef + Math.sqrt(bCoef * bCoef - 4.0 * this.aCoef * cCoef)) / (2.0 * this.aCoef);
    }
}

