/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.impl.rate;

import io.hyperfoil.core.impl.rate.SequentialRateGenerator;
import java.util.Random;

final class PoissonConstantRateGenerator
extends SequentialRateGenerator {
    private final Random random;
    private final double fireTimesPerSec;

    PoissonConstantRateGenerator(Random random, double fireTimesPerSec) {
        this.random = random;
        this.fireTimesPerSec = fireTimesPerSec;
        this.fireTimeMs = this.nextFireTimeMs(0.0);
    }

    @Override
    protected double nextFireTimeMs(double elapsedTimeMs) {
        return elapsedTimeMs + 1000.0 * -Math.log(Math.max(1.0E-20, this.random.nextDouble())) / this.fireTimesPerSec;
    }
}

