/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.impl.rate;

import io.hyperfoil.core.impl.rate.FunctionalRateGenerator;

final class ConstantRateGenerator
extends FunctionalRateGenerator {
    private final double fireTimesPerSec;

    ConstantRateGenerator(double fireTimesPerSec) {
        this.fireTimesPerSec = fireTimesPerSec;
    }

    @Override
    protected long computeFireTimes(long elapsedTimeMs) {
        return (long)((double)elapsedTimeMs * this.fireTimesPerSec / 1000.0);
    }

    @Override
    protected double computeFireTimeMs(long targetFireTimes) {
        return (double)(1000L * targetFireTimes) / this.fireTimesPerSec;
    }
}

