/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.impl;

import io.hyperfoil.api.BenchmarkExecutionException;
import io.hyperfoil.api.collection.ElasticPool;
import io.hyperfoil.api.config.Benchmark;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.session.ControllerListener;
import io.hyperfoil.api.session.GlobalData;
import io.hyperfoil.api.session.PhaseInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.api.session.ThreadData;
import io.hyperfoil.api.statistics.SessionStatistics;
import io.hyperfoil.api.statistics.Statistics;
import io.hyperfoil.core.api.Plugin;
import io.hyperfoil.core.api.PluginRunData;
import io.hyperfoil.core.impl.AffinityAwareSessionPool;
import io.hyperfoil.core.impl.ConnectionStatsConsumer;
import io.hyperfoil.core.impl.EventLoopFactory;
import io.hyperfoil.core.impl.PhaseInstanceImpl;
import io.hyperfoil.core.impl.SessionStatsConsumer;
import io.hyperfoil.core.session.AgentDataImpl;
import io.hyperfoil.core.session.GlobalDataImpl;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.session.ThreadDataImpl;
import io.hyperfoil.core.util.CpuWatchdog;
import io.hyperfoil.impl.Util;
import io.hyperfoil.internal.Properties;
import io.netty.channel.EventLoop;
import io.netty.channel.EventLoopGroup;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.EventExecutorGroup;
import io.vertx.core.AsyncResult;
import io.vertx.core.CompositeFuture;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.text.SimpleDateFormat;
import java.time.Clock;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.StreamSupport;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SimulationRunner {
    protected static final Logger log = LogManager.getLogger(SimulationRunner.class);
    private static final Clock DEFAULT_CLOCK = Clock.systemDefaultZone();
    protected final Benchmark benchmark;
    protected final int agentId;
    protected final String runId;
    protected final Map<String, PhaseInstance> instances = new HashMap<String, PhaseInstance>();
    protected final List<Session> sessions = new ArrayList<Session>();
    private final Map<String, SharedResources> sharedResources = new HashMap<String, SharedResources>();
    protected final EventLoopGroup eventLoopGroup;
    protected final EventLoop[] executors;
    private final Queue<Phase> toPrune;
    private final PluginRunData[] runData;
    private ControllerListener controllerListener;
    private final Consumer<Throwable> errorHandler;
    private boolean isDepletedMessageQuietened;
    private Thread jitterWatchdog;
    private CpuWatchdog cpuWatchdog;
    private final GlobalDataImpl[] globalData;
    private final GlobalDataImpl.Collector globalCollector = new GlobalDataImpl.Collector();

    public SimulationRunner(Benchmark benchmark, String runId, int agentId, Consumer<Throwable> errorHandler) {
        this.eventLoopGroup = EventLoopFactory.INSTANCE.create(benchmark.threads(agentId));
        this.executors = (EventLoop[])StreamSupport.stream(this.eventLoopGroup.spliterator(), false).map(EventLoop.class::cast).toArray(EventLoop[]::new);
        this.benchmark = benchmark;
        this.runId = runId;
        this.agentId = agentId;
        if (benchmark.phases().isEmpty()) {
            throw new BenchmarkDefinitionException("This benchmark does not have any phases, nothing to do!");
        }
        this.toPrune = new ArrayBlockingQueue<Phase>(benchmark.phases().size());
        this.runData = (PluginRunData[])benchmark.plugins().stream().map(config -> Plugin.lookup(config).createRunData(benchmark, this.executors, agentId)).toArray(PluginRunData[]::new);
        this.errorHandler = errorHandler;
        this.globalData = (GlobalDataImpl[])Arrays.stream(this.executors).map(GlobalDataImpl::new).toArray(GlobalDataImpl[]::new);
    }

    public void setControllerListener(ControllerListener controllerListener) {
        this.controllerListener = controllerListener;
    }

    public void init() {
        long initSimulationStartTime = System.currentTimeMillis();
        AgentDataImpl agentData = new AgentDataImpl();
        ThreadData[] threadData = new ThreadData[this.executors.length];
        Arrays.setAll(threadData, executorId -> new ThreadDataImpl());
        for (Phase def : this.benchmark.phases()) {
            SharedResources sharedResources;
            if (def.sharedResources == null) {
                sharedResources = SharedResources.NONE;
            } else {
                sharedResources = this.sharedResources.get(def.sharedResources);
                if (sharedResources == null) {
                    sharedResources = new SharedResources(this.executors.length);
                    sharedResources.sessions = new ArrayList<Session>();
                    ArrayList<Session> phaseSessions = sharedResources.sessions;
                    SessionStatistics[] statistics = sharedResources.statistics;
                    Supplier<Session> sessionSupplier = () -> {
                        Session session;
                        int executorId;
                        List<Session> list = this.sessions;
                        synchronized (list) {
                            executorId = phaseSessions.size() % this.executors.length;
                            session = SessionFactory.create(def.scenario, executorId, this.sessions.size());
                            this.sessions.add(session);
                            phaseSessions.add(session);
                        }
                        session.attach((EventExecutor)this.executors[executorId], threadData[executorId], agentData, (GlobalData)this.globalData[executorId], statistics[executorId]);
                        for (int i = 0; i < this.runData.length; ++i) {
                            this.runData[i].initSession(session, executorId, def.scenario, DEFAULT_CLOCK);
                        }
                        session.reserve(def.scenario);
                        return session;
                    };
                    sharedResources.sessionPool = new AffinityAwareSessionPool((EventExecutor[])this.executors, sessionSupplier);
                    this.sharedResources.put(def.sharedResources, sharedResources);
                }
            }
            PhaseInstance phase = PhaseInstanceImpl.newInstance(def, this.runId, this.agentId);
            this.instances.put(def.name(), phase);
            phase.setComponents(sharedResources.sessionPool, sharedResources.sessions, this::phaseChanged);
            phase.runOnFailedSessionAcquisition(() -> {
                if (!this.isDepletedMessageQuietened) {
                    log.warn("Pool depleted, throttling execution! Enable trace logging to see subsequent pool depletion messages.");
                    this.isDepletedMessageQuietened = true;
                } else {
                    log.trace("Pool depleted, throttling execution!");
                }
            });
            phase.reserveSessions();
        }
        this.runGC();
        this.jitterWatchdog = new Thread(this::observeJitter, "jitter-watchdog");
        this.jitterWatchdog.setDaemon(true);
        this.cpuWatchdog = new CpuWatchdog(this.errorHandler, () -> this.instances.values().stream().anyMatch(p -> !p.definition().isWarmup));
        this.cpuWatchdog.start();
        log.info("Simulation initialization took {} ms", (Object)(System.currentTimeMillis() - initSimulationStartTime));
    }

    public void openConnections(Function<Callable<Void>, Future<Void>> blockingHandler, Handler<AsyncResult<Void>> handler) {
        ArrayList futures = new ArrayList();
        for (PluginRunData plugin : this.runData) {
            plugin.openConnections(blockingHandler, futures::add);
        }
        CompositeFuture composite = CompositeFuture.join(futures);
        composite.onComplete(result -> {
            if (result.failed()) {
                log.error("One of the HTTP client pools failed to start.");
            }
            handler.handle((Object)result.mapEmpty());
            this.jitterWatchdog.start();
        });
    }

    private void observeJitter() {
        long period = Properties.getLong((String)"io.hyperfoil.jitter.watchdog.period", (long)50L);
        long threshold = Properties.getLong((String)"io.hyperfoil.jitter.watchdog.threshold", (long)100L);
        long lastTimestamp = System.nanoTime();
        while (true) {
            try {
                Thread.sleep(period);
            }
            catch (InterruptedException e) {
                log.debug("Interrupted, terminating jitter watchdog");
                return;
            }
            long currentTimestamp = System.nanoTime();
            long delay = TimeUnit.NANOSECONDS.toMillis(currentTimestamp - lastTimestamp);
            if (delay > threshold) {
                String message = String.format("%s | Jitter watchdog was not invoked for %d ms (threshold is %d ms); please check your GC settings.", new SimpleDateFormat("HH:mm:ss.SSS").format(new Date()), delay, threshold);
                log.error(message);
                this.errorHandler.accept((Throwable)new BenchmarkExecutionException(message));
            }
            lastTimestamp = currentTimestamp;
        }
    }

    protected CompletableFuture<Void> phaseChanged(Phase phase, PhaseInstance.Status status, boolean sessionLimitExceeded, Throwable error) {
        if (!phase.isWarmup) {
            if (status == PhaseInstance.Status.RUNNING) {
                this.cpuWatchdog.notifyPhaseStart(phase.name);
            } else if (status.isFinished()) {
                this.cpuWatchdog.notifyPhaseEnd(phase.name);
            }
        }
        if (status == PhaseInstance.Status.TERMINATED) {
            return this.completePhase(phase).whenComplete((nil, e) -> this.notifyAndScheduleForPruning(phase, status, sessionLimitExceeded, error != null ? error : e, this.globalCollector.extract()));
        }
        this.notifyAndScheduleForPruning(phase, status, sessionLimitExceeded, error, null);
        return Util.COMPLETED_VOID_FUTURE;
    }

    private CompletableFuture<Void> completePhase(Phase phase) {
        SharedResources resources = this.sharedResources.get(phase.sharedResources);
        if (resources == null) {
            return Util.COMPLETED_VOID_FUTURE;
        }
        ArrayList futures = new ArrayList(this.executors.length);
        long now = System.currentTimeMillis();
        for (int i = 0; i < this.executors.length; ++i) {
            SessionStatistics statistics = resources.statistics[i];
            if (this.executors[i].inEventLoop()) {
                if (statistics != null) {
                    this.applyToPhase(statistics, phase, now, Statistics::end);
                }
                this.globalCollector.collect(phase.name, this.globalData[i]);
                continue;
            }
            CompletableFuture cf = new CompletableFuture();
            futures.add(cf);
            GlobalDataImpl gd = this.globalData[i];
            this.executors[i].execute(() -> {
                try {
                    this.globalCollector.collect(phase.name, gd);
                    if (statistics != null) {
                        this.applyToPhase(statistics, phase, now, Statistics::end);
                    }
                    cf.complete(null);
                }
                catch (Throwable t) {
                    cf.completeExceptionally(t);
                }
            });
        }
        return CompletableFuture.allOf(futures.toArray(new CompletableFuture[0]));
    }

    private void notifyAndScheduleForPruning(Phase phase, PhaseInstance.Status status, boolean sessionLimitExceeded, Throwable error, Map<String, GlobalData.Element> globalData) {
        if (this.controllerListener != null) {
            this.controllerListener.onPhaseChange(phase, status, sessionLimitExceeded, error, globalData);
        }
        if (status == PhaseInstance.Status.TERMINATED) {
            this.toPrune.add(phase);
        }
    }

    public void shutdown() {
        if (this.jitterWatchdog != null) {
            this.jitterWatchdog.interrupt();
        }
        if (this.cpuWatchdog != null) {
            this.cpuWatchdog.stop();
        }
        for (PluginRunData plugin : this.runData) {
            plugin.shutdown();
        }
        this.eventLoopGroup.shutdownGracefully(0L, 10L, TimeUnit.SECONDS);
        for (Session session : this.sessions) {
            SessionFactory.destroy(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void visitSessions(Consumer<Session> consumer) {
        List<Session> list = this.sessions;
        synchronized (list) {
            for (int i = 0; i < this.sessions.size(); ++i) {
                Session session = this.sessions.get(i);
                consumer.accept(session);
            }
        }
    }

    public void visitStatistics(Consumer<SessionStatistics> consumer) {
        Phase phase;
        for (SharedResources sharedResources : this.sharedResources.values()) {
            if (sharedResources.currentPhase == null) continue;
            for (SessionStatistics statistics : sharedResources.statistics) {
                consumer.accept(statistics);
            }
        }
        while ((phase = this.toPrune.poll()) != null) {
            Phase phase2 = phase;
            for (SharedResources sharedResources : this.sharedResources.values()) {
                if (sharedResources.statistics == null) continue;
                SessionStatistics[] sessionStatistics = sharedResources.statistics;
                for (int i = 0; i < sessionStatistics.length; ++i) {
                    SessionStatistics statistics = sessionStatistics[i];
                    this.executors[i].execute(() -> statistics.prune(phase2));
                }
            }
        }
    }

    public void visitStatistics(Phase phase, Consumer<SessionStatistics> consumer) {
        SharedResources sharedResources = this.sharedResources.get(phase.sharedResources);
        if (sharedResources == null || sharedResources.statistics == null) {
            return;
        }
        for (SessionStatistics statistics : sharedResources.statistics) {
            consumer.accept(statistics);
        }
    }

    public void visitSessionPoolStats(SessionStatsConsumer consumer) {
        for (SharedResources sharedResources : this.sharedResources.values()) {
            if (sharedResources.currentPhase == null) continue;
            this.recordSessionStats(sharedResources.sessionPool, sharedResources.currentPhase.definition().name(), consumer);
        }
    }

    public void visitSessionPoolStats(Phase phase, SessionStatsConsumer consumer) {
        SharedResources sharedResources = this.sharedResources.get(phase.sharedResources);
        if (sharedResources != null) {
            this.recordSessionStats(sharedResources.sessionPool, phase.name(), consumer);
        }
    }

    private void recordSessionStats(ElasticPool<Session> sessionPool, String phaseName, SessionStatsConsumer consumer) {
        int minUsed = sessionPool.minUsed();
        int maxUsed = sessionPool.maxUsed();
        sessionPool.resetStats();
        if (minUsed <= maxUsed && maxUsed != 0) {
            consumer.accept(phaseName, minUsed, maxUsed);
        }
    }

    public void visitConnectionStats(ConnectionStatsConsumer consumer) {
        for (PluginRunData plugin : this.runData) {
            plugin.visitConnectionStats(consumer);
        }
    }

    public void startPhase(String phase) {
        PhaseInstance phaseInstance = this.instances.get(phase);
        SharedResources sharedResources = this.sharedResources.get(phaseInstance.definition().sharedResources);
        if (sharedResources != null) {
            sharedResources.currentPhase = phaseInstance;
            if (sharedResources.statistics != null) {
                long now = System.currentTimeMillis();
                for (int i = 0; i < this.executors.length; ++i) {
                    SessionStatistics statistics = sharedResources.statistics[i];
                    this.executors[i].execute(() -> this.applyToPhase(statistics, phaseInstance.definition(), now, Statistics::start));
                }
            }
        }
        phaseInstance.start((EventExecutorGroup)this.eventLoopGroup);
    }

    private void applyToPhase(SessionStatistics statistics, Phase phase, long now, BiConsumer<Statistics, Long> f) {
        for (int j = 0; j < statistics.size(); ++j) {
            if (statistics.phase(j) != phase) continue;
            for (Statistics s : statistics.stats(j).values()) {
                f.accept(s, now);
            }
        }
    }

    public void finishPhase(String phase) {
        this.instances.get(phase).finish();
    }

    public void tryTerminatePhase(String phase) {
        this.instances.get(phase).tryTerminate();
    }

    public void terminatePhase(String phase) {
        this.instances.get(phase).terminate();
    }

    public List<String> listConnections() {
        ArrayList<String> list = new ArrayList<String>();
        for (PluginRunData plugin : this.runData) {
            plugin.listConnections(list::add);
        }
        return list;
    }

    public String getCpuUsage(String name) {
        return this.cpuWatchdog.getCpuUsage(name);
    }

    public void addGlobalData(Map<String, GlobalData.Element> globalData) {
        for (int i = 0; i < this.executors.length; ++i) {
            GlobalDataImpl data = this.globalData[i];
            this.executors[i].execute(() -> data.add(globalData));
        }
    }

    private void runGC() {
        long start = System.currentTimeMillis();
        if (!Properties.getBoolean((String)"io.hyperfoil.gc.check.enabled")) {
            this.runSystemGC();
        } else {
            log.info("Running additional GC check!");
            ArrayList<GarbageCollectorMXBean> enabledBeans = new ArrayList<GarbageCollectorMXBean>();
            long beforeGcCount = 0L;
            for (GarbageCollectorMXBean bean : ManagementFactory.getGarbageCollectorMXBeans()) {
                long count = bean.getCollectionCount();
                if (count == -1L) continue;
                enabledBeans.add(bean);
                beforeGcCount += bean.getCollectionCount();
            }
            this.runSystemGC();
            int MAX_WAIT_MS = 10000;
            if (enabledBeans.isEmpty()) {
                log.warn("MXBeans can not report GC info. System.gc() invoked, but cannot check whether GC actually happened!");
                return;
            }
            boolean gcHappened = false;
            boolean stable = false;
            long checkStart = System.nanoTime();
            while (TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - checkStart) < 10000L) {
                long afterGcCount = 0L;
                for (GarbageCollectorMXBean bean : enabledBeans) {
                    afterGcCount += bean.getCollectionCount();
                }
                if (!gcHappened) {
                    if (afterGcCount - beforeGcCount >= 2L) {
                        gcHappened = true;
                    }
                } else {
                    if (afterGcCount == beforeGcCount) {
                        stable = true;
                        break;
                    }
                    beforeGcCount = afterGcCount;
                }
                try {
                    TimeUnit.MILLISECONDS.sleep(20L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            if (!stable) {
                if (gcHappened) {
                    log.warn("System.gc() was invoked but unable to wait while GC stopped, is GC too asynchronous?");
                } else {
                    log.warn("System.gc() was invoked but couldn't detect a GC occurring, is System.gc() disabled?");
                }
            }
        }
        log.info("Overall GC run took {} ms", (Object)(System.currentTimeMillis() - start));
    }

    private void runSystemGC() {
        long actualGCRun = System.currentTimeMillis();
        System.runFinalization();
        System.gc();
        System.runFinalization();
        System.gc();
        log.info("GC execution took {} ms", (Object)(System.currentTimeMillis() - actualGCRun));
    }

    private static class SharedResources {
        static final SharedResources NONE = new SharedResources(0);
        PhaseInstance currentPhase;
        ElasticPool<Session> sessionPool;
        List<Session> sessions;
        SessionStatistics[] statistics;

        SharedResources(int executorCount) {
            this.statistics = new SessionStatistics[executorCount];
            for (int executorId = 0; executorId < executorCount; ++executorId) {
                this.statistics[executorId] = new SessionStatistics();
            }
        }
    }
}

