/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.impl;

import io.hyperfoil.api.collection.ElasticPool;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Model;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.session.PhaseChangeHandler;
import io.hyperfoil.api.session.PhaseInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.impl.OpenModel;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.IntStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class PhaseInstanceImpl
implements PhaseInstance {
    protected static final Logger log = LogManager.getLogger(PhaseInstanceImpl.class);
    protected static final boolean trace = log.isTraceEnabled();
    private static final Map<Class<? extends Model>, PhaseCtor> constructors = new HashMap<Class<? extends Model>, PhaseCtor>();
    protected final Phase def;
    private final String runId;
    private final int agentId;
    private final int agentThreads;
    private final int agentFirstThreadId;
    protected ElasticPool<Session> sessionPool;
    protected List<Session> sessionList;
    private PhaseChangeHandler phaseChangeHandler;
    protected volatile PhaseInstance.Status status = PhaseInstance.Status.NOT_STARTED;
    protected long absoluteStartTime;
    protected String absoluteStartTimeString;
    protected AtomicInteger activeSessions = new AtomicInteger(0);
    private volatile Throwable error;
    private volatile boolean sessionLimitExceeded;
    private Runnable failedSessionAcquisitionAction;

    public static PhaseInstance newInstance(Phase def, String runId, int agentId) {
        PhaseCtor ctor = constructors.get(def.model.getClass());
        if (ctor == null) {
            throw new BenchmarkDefinitionException("Unknown phase type: " + String.valueOf(def.model));
        }
        return ctor.create(def, runId, agentId);
    }

    protected PhaseInstanceImpl(Phase def, String runId, int agentId) {
        this.def = def;
        this.runId = runId;
        this.agentId = agentId;
        this.agentThreads = def.benchmark().threads(agentId);
        this.agentFirstThreadId = IntStream.range(0, agentId).map(id -> def.benchmark().threads(id)).sum();
    }

    public Phase definition() {
        return this.def;
    }

    public PhaseInstance.Status status() {
        return this.status;
    }

    public long absoluteStartTime() {
        return this.absoluteStartTime;
    }

    public String absoluteStartTimeAsString() {
        return this.absoluteStartTimeString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start(EventExecutorGroup executorGroup) {
        PhaseInstanceImpl phaseInstanceImpl = this;
        synchronized (phaseInstanceImpl) {
            assert (this.status == PhaseInstance.Status.NOT_STARTED) : "Status is " + String.valueOf(this.status);
            this.status = PhaseInstance.Status.RUNNING;
        }
        this.recordAbsoluteStartTime();
        log.debug("{} changing status to RUNNING", (Object)this.def.name);
        this.phaseChangeHandler.onChange(this.def, PhaseInstance.Status.RUNNING, false, this.error).thenRun(() -> this.proceedOnStarted(executorGroup));
    }

    protected void proceedOnStarted(EventExecutorGroup executorGroup) {
        this.proceed(executorGroup);
    }

    protected void recordAbsoluteStartTime() {
        this.absoluteStartTime = System.currentTimeMillis();
        this.absoluteStartTimeString = String.valueOf(this.absoluteStartTime);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void finish() {
        PhaseInstanceImpl phaseInstanceImpl = this;
        synchronized (phaseInstanceImpl) {
            if (this.status == PhaseInstance.Status.RUNNING) {
                this.status = PhaseInstance.Status.FINISHED;
                log.debug("{} changing status to FINISHED", (Object)this.def.name);
            } else {
                log.debug("{} already in state {}, not finishing", (Object)this.def.name, (Object)this.status);
            }
        }
        this.phaseChangeHandler.onChange(this.def, PhaseInstance.Status.FINISHED, this.sessionLimitExceeded, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tryTerminate() {
        assert (this.status.isFinished());
        if (this.activeSessions.compareAndSet(0, Integer.MIN_VALUE)) {
            this.setTerminated();
        } else if (this.sessionList != null && this.status == PhaseInstance.Status.TERMINATING) {
            List<Session> list = this.sessionList;
            synchronized (list) {
                for (int i = 0; i < this.sessionList.size(); ++i) {
                    Session session = this.sessionList.get(i);
                    if (!session.isActive()) continue;
                    session.proceed();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void terminate() {
        PhaseInstanceImpl phaseInstanceImpl = this;
        synchronized (phaseInstanceImpl) {
            if (this.status.ordinal() < PhaseInstance.Status.TERMINATED.ordinal()) {
                this.status = PhaseInstance.Status.TERMINATING;
            }
        }
        log.debug("{} changing status to TERMINATING", (Object)this.def.name);
        this.tryTerminate();
    }

    public void runOnFailedSessionAcquisition(Runnable action) {
        this.failedSessionAcquisitionAction = action;
    }

    public void setComponents(ElasticPool<Session> sessionPool, List<Session> sessionList, PhaseChangeHandler phaseChangeHandler) {
        this.sessionPool = sessionPool;
        this.sessionList = sessionList;
        this.phaseChangeHandler = phaseChangeHandler;
    }

    public void notifyFinished(Session session) {
        if (session != null) {
            this.sessionPool.release((Object)session);
        }
        int numActive = this.activeSessions.decrementAndGet();
        if (trace) {
            log.trace("#{} NotifyFinished, {} has {} active sessions", (Object)(session == null ? -1 : session.uniqueId()), (Object)this.def.name, (Object)numActive);
        }
        if (numActive < 0) {
            throw new IllegalStateException(this.def.name + " has " + numActive + " active sessions");
        }
        if (numActive == 0 && this.status.isFinished() && this.activeSessions.compareAndSet(0, Integer.MIN_VALUE)) {
            this.setTerminated();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTerminated() {
        PhaseInstanceImpl phaseInstanceImpl = this;
        synchronized (phaseInstanceImpl) {
            this.status = PhaseInstance.Status.TERMINATED;
        }
        log.debug("{} changing status to TERMINATED", (Object)this.def.name);
        this.phaseChangeHandler.onChange(this.def, this.status, false, this.error);
    }

    public void fail(Throwable error) {
        this.error = error;
        this.terminate();
    }

    public Throwable getError() {
        return this.error;
    }

    public String runId() {
        return this.runId;
    }

    public int agentId() {
        return this.agentId;
    }

    public int agentThreads() {
        return this.agentThreads;
    }

    public int agentFirstThreadId() {
        return this.agentFirstThreadId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatsComplete() {
        PhaseInstanceImpl phaseInstanceImpl = this;
        synchronized (phaseInstanceImpl) {
            if (this.status != PhaseInstance.Status.TERMINATED) {
                throw new IllegalStateException();
            }
            this.status = PhaseInstance.Status.STATS_COMPLETE;
        }
        log.debug("{} changing status to STATS_COMPLETE", (Object)this.def.name);
    }

    protected boolean startNewSession() {
        Session session;
        int numActive = this.activeSessions.incrementAndGet();
        if (numActive < 0) {
            return false;
        }
        if (trace) {
            log.trace("{} has {} active sessions", (Object)this.def.name, (Object)numActive);
        }
        try {
            session = (Session)this.sessionPool.acquire();
        }
        catch (Throwable t) {
            log.error("Error during session acquisition", t);
            this.notifyFinished(null);
            return false;
        }
        if (session == null) {
            this.noSessionsAvailable();
            return false;
        }
        session.start((PhaseInstance)this);
        return true;
    }

    private void noSessionsAvailable() {
        if (this.failedSessionAcquisitionAction != null) {
            this.failedSessionAcquisitionAction.run();
        }
        if (!this.sessionLimitExceeded) {
            this.sessionLimitExceeded = true;
        }
        this.notifyFinished(null);
    }

    static {
        constructors.put(Model.AtOnce.class, AtOnce::new);
        constructors.put(Model.Always.class, Always::new);
        constructors.put(Model.RampRate.class, OpenModel::rampRate);
        constructors.put(Model.ConstantRate.class, OpenModel::constantRate);
        constructors.put(Model.Sequentially.class, Sequentially::new);
        constructors.put(Model.Noop.class, Noop::new);
    }

    static interface PhaseCtor {
        public PhaseInstance create(Phase var1, String var2, int var3);
    }

    public static class Noop
    extends PhaseInstanceImpl {
        protected Noop(Phase def, String runId, int agentId) {
            super(def, runId, agentId);
        }

        public void proceed(EventExecutorGroup executorGroup) {
        }

        public void reserveSessions() {
        }
    }

    public static class Sequentially
    extends PhaseInstanceImpl {
        private int counter = 0;

        public Sequentially(Phase def, String runId, int agentId) {
            super(def, runId, agentId);
        }

        public void proceed(EventExecutorGroup executorGroup) {
            assert (this.activeSessions.get() == 0);
            this.startNewSession();
        }

        public void reserveSessions() {
            this.sessionPool.reserve(1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notifyFinished(Session session) {
            Model.Sequentially model = (Model.Sequentially)this.def.model;
            if (++this.counter >= model.repeats) {
                Sequentially sequentially = this;
                synchronized (sequentially) {
                    if (this.status.ordinal() < PhaseInstance.Status.TERMINATING.ordinal()) {
                        this.status = PhaseInstance.Status.TERMINATING;
                        log.debug("{} changing status to TERMINATING", (Object)this.def.name);
                    } else {
                        log.warn("{} not terminating because it is already {}", (Object)this.def.name, (Object)this.status);
                    }
                }
                super.notifyFinished(session);
            } else {
                session.start((PhaseInstance)this);
            }
        }
    }

    public static class Always
    extends PhaseInstanceImpl {
        final int users;

        public Always(Phase def, String runId, int agentId) {
            super(def, runId, agentId);
            Model.Always model = (Model.Always)def.model;
            this.users = model.users > 0 ? def.benchmark().slice(model.users, agentId) : (model.usersPerAgent > 0 ? model.usersPerAgent : (model.usersPerThread > 0 ? model.usersPerThread * def.benchmark().threads(agentId) : 0));
        }

        public void proceed(EventExecutorGroup executorGroup) {
            assert (this.activeSessions.get() == 0);
            for (int i = 0; i < this.users; ++i) {
                this.startNewSession();
            }
        }

        public void reserveSessions() {
            if (this.users > 0) {
                this.sessionPool.reserve(this.users);
            }
        }

        @Override
        public void notifyFinished(Session session) {
            if (this.status.isFinished() || session == null) {
                super.notifyFinished(session);
            } else {
                session.start((PhaseInstance)this);
            }
        }
    }

    public static class AtOnce
    extends PhaseInstanceImpl {
        private final int users;

        public AtOnce(Phase def, String runId, int agentId) {
            super(def, runId, agentId);
            Model.AtOnce model = (Model.AtOnce)def.model;
            this.users = model.users > 0 ? def.benchmark().slice(model.users, agentId) : (model.usersPerAgent > 0 ? model.usersPerAgent : (model.usersPerThread > 0 ? model.usersPerThread * def.benchmark().threads(agentId) : 0));
        }

        public void proceed(EventExecutorGroup executorGroup) {
            assert (this.activeSessions.get() == 0);
            for (int i = 0; i < this.users; ++i) {
                this.startNewSession();
            }
        }

        public void reserveSessions() {
            if (this.users > 0) {
                this.sessionPool.reserve(this.users);
            }
        }
    }
}

