/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.impl;

import io.hyperfoil.api.config.Model;
import io.hyperfoil.api.config.Phase;
import io.hyperfoil.api.session.PhaseInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.impl.PhaseInstanceImpl;
import io.hyperfoil.core.impl.rate.FireTimeListener;
import io.hyperfoil.core.impl.rate.RateGenerator;
import io.netty.util.concurrent.EventExecutorGroup;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

final class OpenModelPhase
extends PhaseInstanceImpl
implements FireTimeListener {
    private final int maxSessions;
    private final AtomicLong throttledUsers = new AtomicLong(0L);
    private final RateGenerator rateGenerator;
    private final long relativeFirstFireTime;

    OpenModelPhase(RateGenerator rateGenerator, Phase def, String runId, int agentId) {
        super(def, runId, agentId);
        this.rateGenerator = rateGenerator;
        this.maxSessions = Math.max(1, def.benchmark().slice(((Model.OpenModel)def.model).maxSessions, agentId));
        this.relativeFirstFireTime = rateGenerator.lastComputedFireTimeMs();
    }

    public void reserveSessions() {
        if (log.isDebugEnabled()) {
            log.debug("Phase {} reserving {} sessions", (Object)this.def.name, (Object)this.maxSessions);
        }
        this.sessionPool.reserve(this.maxSessions);
    }

    @Override
    protected void proceedOnStarted(EventExecutorGroup executorGroup) {
        long elapsedMs = System.currentTimeMillis() - this.absoluteStartTime;
        long remainingMsToFirstFireTime = this.relativeFirstFireTime - elapsedMs;
        if (remainingMsToFirstFireTime > 0L) {
            executorGroup.schedule(() -> this.proceed(executorGroup), remainingMsToFirstFireTime, TimeUnit.MILLISECONDS);
        } else {
            this.proceed(executorGroup);
        }
    }

    public void proceed(EventExecutorGroup executorGroup) {
        if (this.status.isFinished()) {
            return;
        }
        long realFireTimeMs = System.currentTimeMillis();
        long elapsedTimeMs = realFireTimeMs - this.absoluteStartTime;
        assert (elapsedTimeMs >= this.rateGenerator.lastComputedFireTimeMs());
        long expectedNextFireTimeMs = this.rateGenerator.computeNextFireTime(elapsedTimeMs, this);
        long rateGenerationDelayMs = System.currentTimeMillis() - realFireTimeMs;
        assert (rateGenerationDelayMs >= 0L);
        long scheduledFireDelayMs = Math.max(0L, expectedNextFireTimeMs - elapsedTimeMs - rateGenerationDelayMs);
        if (trace) {
            log.trace("{}: {} after start, {} started ({} throttled), next user in {} ms, scheduling decisions took {} ms", (Object)this.def.name, (Object)elapsedTimeMs, (Object)this.rateGenerator.fireTimes(), (Object)this.throttledUsers, (Object)scheduledFireDelayMs, (Object)rateGenerationDelayMs);
        }
        if (scheduledFireDelayMs <= 0L) {
            executorGroup.execute(() -> this.proceed(executorGroup));
        } else {
            executorGroup.schedule(() -> this.proceed(executorGroup), scheduledFireDelayMs, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void onFireTime() {
        if (!this.startNewSession()) {
            this.throttledUsers.incrementAndGet();
        }
    }

    @Override
    public void notifyFinished(Session session) {
        if (session != null && !this.status.isFinished()) {
            long throttled = this.throttledUsers.get();
            while (throttled != 0L) {
                if (this.throttledUsers.compareAndSet(throttled, throttled - 1L)) {
                    session.start((PhaseInstance)this);
                    return;
                }
                throttled = this.throttledUsers.get();
            }
        }
        super.notifyFinished(session);
    }
}

