/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.impl;

import io.hyperfoil.api.collection.ElasticPool;
import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.LongAdder;
import java.util.function.Supplier;

public class LockBasedElasticPool<T>
implements ElasticPool<T> {
    protected final LongAdder used = new LongAdder();
    private final Supplier<T> initSupplier;
    private final Supplier<T> depletionSupplier;
    protected volatile int minUsed;
    protected volatile int maxUsed;
    private ArrayBlockingQueue<T> primaryQueue;
    private final BlockingQueue<T> secondaryQueue = new LinkedBlockingQueue<T>();

    public LockBasedElasticPool(Supplier<T> initSupplier, Supplier<T> depletionSupplier) {
        this.initSupplier = initSupplier;
        this.depletionSupplier = depletionSupplier;
    }

    public T acquire() {
        Object object = this.primaryQueue.poll();
        if (object != null) {
            this.incrementUsed();
            return object;
        }
        object = this.secondaryQueue.poll();
        if (object != null) {
            this.incrementUsed();
            return object;
        }
        object = this.depletionSupplier.get();
        if (object != null) {
            this.incrementUsed();
        }
        return object;
    }

    public void release(T object) {
        Objects.requireNonNull(this.primaryQueue);
        this.decrementUsed();
        if (this.primaryQueue.offer(object)) {
            return;
        }
        this.secondaryQueue.add(object);
    }

    public void reserve(int capacity) {
        if (this.primaryQueue == null || this.primaryQueue.size() < capacity) {
            this.primaryQueue = new ArrayBlockingQueue(capacity);
        }
        while (this.primaryQueue.size() < capacity) {
            this.primaryQueue.add(this.initSupplier.get());
        }
    }

    public void incrementUsed() {
        this.used.increment();
        long currentlyUsed = this.used.longValue();
        if (currentlyUsed > (long)this.maxUsed) {
            this.maxUsed = (int)currentlyUsed;
        }
    }

    public void decrementUsed() {
        this.decrementUsed(1);
    }

    public void decrementUsed(int num) {
        this.used.add(-num);
        long currentlyUsed = this.used.longValue();
        if (currentlyUsed < (long)this.minUsed) {
            this.minUsed = (int)currentlyUsed;
        }
        assert (currentlyUsed >= 0L);
    }

    public int minUsed() {
        return this.minUsed;
    }

    public int maxUsed() {
        return this.maxUsed;
    }

    public void resetStats() {
        int current;
        this.minUsed = current = this.used.intValue();
        this.maxUsed = current;
    }

    public int current() {
        return this.used.intValue();
    }
}

