/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.impl;

import io.hyperfoil.api.config.BenchmarkData;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;

public class LocalBenchmarkData
implements BenchmarkData {
    protected final Path benchmarkPath;
    protected final Map<String, byte[]> files = new HashMap<String, byte[]>();

    public LocalBenchmarkData(Path benchmarkPath) {
        this.benchmarkPath = benchmarkPath;
    }

    public InputStream readFile(String file) {
        byte[] bytes = this.files.get(file);
        if (bytes == null) {
            Path path = Paths.get(file, new String[0]);
            if (!path.isAbsolute()) {
                if (this.benchmarkPath == null) {
                    throw new BenchmarkData.MissingFileException(file, "Cannot load relative path " + file, null);
                }
                path = this.benchmarkPath.getParent().resolve(file);
            }
            try {
                bytes = Files.readAllBytes(path);
                this.files.put(file, bytes);
            }
            catch (IOException e) {
                throw new BenchmarkData.MissingFileException(file, "Local file " + file + " (" + String.valueOf(path.toAbsolutePath()) + ") cannot be read.", (Throwable)e);
            }
        }
        return new ByteArrayInputStream(bytes);
    }

    public Map<String, byte[]> files() {
        return this.files;
    }
}

