/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.impl;

import io.hyperfoil.api.collection.ElasticPool;
import io.hyperfoil.api.session.Session;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.FastThreadLocal;
import io.netty.util.internal.PlatformDependent;
import io.netty.util.internal.ThreadExecutorMap;
import java.util.IdentityHashMap;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.atomic.AtomicIntegerArray;
import java.util.function.Supplier;
import org.jctools.queues.MpmcArrayQueue;
import org.jctools.queues.atomic.MpmcAtomicArrayQueue;

public class AffinityAwareSessionPool
implements ElasticPool<Session> {
    private final FastThreadLocal<Integer> localAgentThreadId;
    private final IdentityHashMap<EventExecutor, Integer> agentThreadIdPerExecutor;
    private final Queue<Session>[] localQueues;
    private final Supplier<Session> sessionSupplier;
    private static final int PADDING_INTS = 32;
    private static final int USED_OFFSET = 32;
    private static final int MIN_USED_OFFSET = 64;
    private static final int MAX_USED_OFFSET = 96;
    private static final int COUNTERS_INTS = 128;
    private final AtomicIntegerArray counters;

    public AffinityAwareSessionPool(EventExecutor[] eventExecutors, Supplier<Session> sessionSupplier) {
        this.sessionSupplier = sessionSupplier;
        this.agentThreadIdPerExecutor = new IdentityHashMap(eventExecutors.length);
        this.localQueues = new Queue[eventExecutors.length];
        for (int agentThreadId = 0; agentThreadId < eventExecutors.length; ++agentThreadId) {
            this.agentThreadIdPerExecutor.put(eventExecutors[agentThreadId], agentThreadId);
        }
        this.localAgentThreadId = new FastThreadLocal<Integer>(){

            protected Integer initialValue() {
                EventExecutor eventExecutor = ThreadExecutorMap.currentExecutor();
                return eventExecutor == null ? null : AffinityAwareSessionPool.this.agentThreadIdPerExecutor.get(eventExecutor);
            }
        };
        this.counters = new AtomicIntegerArray(128);
    }

    private int nextWorkStealIndex() {
        return ThreadLocalRandom.current().nextInt(0, this.localQueues.length);
    }

    private int nextWorkStealIndex(int excludeIndex) {
        int workStealIndex;
        int localQueuesCount = this.localQueues.length;
        int n = workStealIndex = localQueuesCount == 2 ? excludeIndex : ThreadLocalRandom.current().nextInt(0, localQueuesCount);
        if (workStealIndex == excludeIndex && ++workStealIndex == localQueuesCount) {
            workStealIndex = 0;
        }
        return workStealIndex;
    }

    public Session acquire() {
        Integer boxedAgentThreadId = (Integer)this.localAgentThreadId.get();
        if (boxedAgentThreadId == null) {
            return this.acquireFromLocalQueues();
        }
        Queue<Session>[] localQueues = this.localQueues;
        int agentThreadId = boxedAgentThreadId;
        Session session = localQueues[agentThreadId].poll();
        if (session != null) {
            this.incrementUsed();
            return session;
        }
        if (localQueues.length == 1) {
            return null;
        }
        return this.acquireFromOtherLocalQueues(localQueues, agentThreadId);
    }

    private Session acquireFromLocalQueues() {
        int currentIndex = this.nextWorkStealIndex();
        Queue<Session>[] localQueues = this.localQueues;
        int localQueuesCount = localQueues.length;
        for (Queue<Session> localQueue : localQueues) {
            Session session = localQueue.poll();
            if (session != null) {
                this.incrementUsed();
                return session;
            }
            if (++currentIndex != localQueuesCount) continue;
            currentIndex = 0;
        }
        return null;
    }

    private Session acquireFromOtherLocalQueues(Queue<Session>[] localQueues, int agentThreadIdToSkip) {
        int currentIndex = this.nextWorkStealIndex(agentThreadIdToSkip);
        int localQueuesCount = localQueues.length;
        for (int i = 0; i < localQueuesCount; ++i) {
            Session session;
            Queue<Session> localQ;
            if (currentIndex != agentThreadIdToSkip && (localQ = localQueues[currentIndex]) != null && (session = localQ.poll()) != null) {
                this.incrementUsed();
                return session;
            }
            if (++currentIndex != localQueuesCount) continue;
            currentIndex = 0;
        }
        return null;
    }

    private void incrementUsed() {
        int maxUsed;
        AtomicIntegerArray counters = this.counters;
        int used = counters.incrementAndGet(32);
        if (used > (maxUsed = counters.get(96))) {
            counters.lazySet(96, used);
        }
    }

    private void decrementUsed() {
        AtomicIntegerArray counters = this.counters;
        int used = counters.decrementAndGet(32);
        int minUsed = counters.get(64);
        if (minUsed > 0 && used < minUsed) {
            counters.lazySet(64, used);
        }
    }

    public void release(Session session) {
        Objects.requireNonNull(session);
        Queue<Session> localQueue = this.localQueues[session.agentThreadId()];
        this.decrementUsed();
        localQueue.add(session);
    }

    public void reserve(int capacity) {
        int totalCapacity = this.getLocalQueuesCapacity();
        if (totalCapacity >= capacity) {
            return;
        }
        this.moveNewSessionsToLocalQueues(capacity, totalCapacity);
    }

    private int getLocalQueuesCapacity() {
        int totalCapacity = 0;
        for (Queue<Session> localQueue : this.localQueues) {
            if (localQueue == null) continue;
            totalCapacity += localQueue.size();
        }
        return totalCapacity;
    }

    private void moveNewSessionsToLocalQueues(int requiredCapacity, int currentCapacity) {
        int i;
        int newCapacity = requiredCapacity - currentCapacity;
        int perEventExecutorNewCapacity = (int)Math.ceil((double)newCapacity / (double)this.localQueues.length);
        Supplier<Session> sessionSupplier = this.sessionSupplier;
        Queue<Session>[] localQueues = this.localQueues;
        IdentityHashMap<EventExecutor, Integer> agentThreadIdPerExecutor = this.agentThreadIdPerExecutor;
        boolean[] localQueueReservedCapacity = new boolean[localQueues.length];
        for (i = 0; i < newCapacity; ++i) {
            Session newSession = sessionSupplier.get();
            EventExecutor eventExecutor = newSession.executor();
            Integer boxedAgentThreadId = agentThreadIdPerExecutor.get(eventExecutor);
            if (boxedAgentThreadId == null) {
                throw new IllegalStateException("No agentThreadId for executor " + String.valueOf(eventExecutor));
            }
            int agentThreadId = boxedAgentThreadId;
            Queue<Session> localQueue = localQueues[agentThreadId];
            if (!localQueueReservedCapacity[agentThreadId]) {
                localQueueReservedCapacity[agentThreadId] = true;
                if (localQueue == null) {
                    localQueues[agentThreadId] = localQueue = this.createLocalQueue(perEventExecutorNewCapacity);
                } else {
                    Queue<Session> newLocalQueue = this.createLocalQueue(localQueue.size() + perEventExecutorNewCapacity);
                    newLocalQueue.addAll(localQueue);
                    localQueue.clear();
                    localQueue = newLocalQueue;
                    localQueues[agentThreadId] = newLocalQueue;
                }
            }
            if (localQueue.offer(newSession)) continue;
            throw new IllegalStateException("Failed to add new session to local queue: sessions are not fairly distributed");
        }
        for (i = 0; i < localQueueReservedCapacity.length; ++i) {
            Queue<Session> localQ;
            if (localQueueReservedCapacity[i] || (localQ = localQueues[i]) != null) continue;
            this.localQueues[i] = localQ = this.createLocalQueue(0);
        }
    }

    private Queue<Session> createLocalQueue(int capacity) {
        if (PlatformDependent.hasUnsafe()) {
            return new MpmcArrayQueue(Math.max(2, capacity));
        }
        return new MpmcAtomicArrayQueue(Math.max(2, capacity));
    }

    public int minUsed() {
        return this.counters.get(64);
    }

    public int maxUsed() {
        return this.counters.get(96);
    }

    public void resetStats() {
        AtomicIntegerArray counters = this.counters;
        int used = counters.get(32);
        counters.lazySet(96, used);
        counters.lazySet(64, used);
    }
}

