/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers.json;

import io.hyperfoil.core.handlers.json.ByteStream;
import java.io.Serializable;
import java.util.Arrays;
import org.jctools.util.Pow2;

public class StreamQueue {
    private ByteStream[] parts;
    private int[] userIndex;
    private int mask;
    private int end = -1;
    private int length = 0;

    public StreamQueue(int initialCapacity) {
        initialCapacity = Pow2.roundToPowerOfTwo((int)initialCapacity);
        this.mask = initialCapacity - 1;
        this.parts = new ByteStream[initialCapacity];
        this.userIndex = new int[initialCapacity];
        Arrays.fill(this.userIndex, -1);
    }

    int firstAvailableIndex() {
        return this.totalAppendedBytes() - this.bytes();
    }

    int bytes() {
        int bytes = 0;
        for (ByteStream part : this.parts) {
            if (part == null) continue;
            bytes += StreamQueue.readableBytesOf(part);
        }
        return bytes;
    }

    int availableCapacityBeforeEnlargement() {
        if (this.end == -1) {
            return this.parts.length;
        }
        int next = this.next(this.end);
        int contiguousNulls = 0;
        for (int i = 0; i < this.parts.length && this.parts[next] == null; ++i) {
            next = this.next(next);
            ++contiguousNulls;
        }
        return contiguousNulls;
    }

    int parts() {
        int count = 0;
        for (ByteStream part : this.parts) {
            if (part == null) continue;
            ++count;
        }
        return count;
    }

    private int totalAppendedBytes() {
        return this.length;
    }

    public int enlargeCapacity(int tail) {
        assert (this.parts[tail] != null);
        int newCapacity = Pow2.roundToPowerOfTwo((int)(this.mask + 2));
        ByteStream[] newParts = new ByteStream[newCapacity];
        int[] newUserIndex = new int[newCapacity];
        int secondHalfToCopy = this.parts.length - tail;
        System.arraycopy(this.parts, tail, newParts, 0, secondHalfToCopy);
        System.arraycopy(this.userIndex, tail, newUserIndex, 0, secondHalfToCopy);
        if (tail > 0) {
            System.arraycopy(this.parts, 0, newParts, secondHalfToCopy, tail);
            System.arraycopy(this.userIndex, 0, newUserIndex, secondHalfToCopy, tail);
        }
        Arrays.fill(newUserIndex, this.userIndex.length, newCapacity, -1);
        this.mask = newCapacity - 1;
        this.end = this.parts.length - 1;
        tail = this.parts.length;
        this.userIndex = newUserIndex;
        Arrays.fill(this.parts, null);
        this.parts = newParts;
        assert (this.parts[tail] == null);
        return tail;
    }

    public int append(ByteStream stream) {
        int newUserIndex;
        ByteStream retained;
        int tail = this.next(this.end);
        if (this.parts[tail] != null) {
            tail = this.enlargeCapacity(tail);
        }
        this.parts[tail] = retained = stream.retain();
        this.userIndex[tail] = newUserIndex = this.length;
        this.length += StreamQueue.readableBytesOf(retained);
        this.end = tail;
        return newUserIndex;
    }

    public void releaseUntil(int index) {
        int i = this.findPartIndexWith(index);
        if (i < 0) {
            return;
        }
        assert (this.end >= 0);
        i = this.prev(i);
        while (this.hasMoreParts(i)) {
            this.releasePart(i);
            i = this.prev(i);
        }
    }

    public int getByte(int index) {
        int i = this.findPartIndexWith(index);
        if (i < 0) {
            return -1;
        }
        ByteStream part = this.parts[i];
        int partIndex = this.partOffset(index, i);
        if (partIndex >= StreamQueue.readableBytesOf(part)) {
            return -1;
        }
        return part.getByte(StreamQueue.readerIndexOf(part, partIndex));
    }

    private int findPartIndexWith(int index) {
        if (index < 0) {
            return -1;
        }
        int i = this.end;
        if (i < 0) {
            return -1;
        }
        while (index < this.userIndex[i]) {
            if (this.hasMoreParts(i = this.prev(i))) continue;
            return -1;
        }
        return i;
    }

    public void reset() {
        if (this.end >= 0) {
            int i = this.end;
            do {
                this.releasePart(i);
            } while (this.hasMoreParts(i = this.prev(i)));
            this.end = -1;
        }
        this.length = 0;
    }

    public <P1, P2> void consume(int startIndex, int endIndex, Consumer<P1, P2> consumer, P1 p1, P2 p2, boolean isComplete) {
        this.validateIndexes(startIndex, endIndex);
        if (startIndex == endIndex) {
            return;
        }
        int i = this.findPartIndexWith(startIndex);
        if (i < 0) {
            throw new IllegalArgumentException("Start index " + startIndex + " not found.");
        }
        int partStartIndex = this.partOffset(startIndex, i);
        boolean isLast = false;
        while (!isLast) {
            ByteStream part = this.parts[i];
            int readableBytes = StreamQueue.readableBytesOf(part);
            int partEndIndex = this.partOffset(endIndex, i);
            isLast = partEndIndex <= readableBytes;
            int length = isLast ? partEndIndex - partStartIndex : readableBytes - partStartIndex;
            if (length > 0) {
                consumer.accept(p1, p2, part, StreamQueue.readerIndexOf(part, partStartIndex), length, isComplete && isLast);
            }
            partStartIndex = 0;
            i = this.next(i);
        }
    }

    private static int readableBytesOf(ByteStream stream) {
        return stream.writerIndex() - stream.readerIndex();
    }

    private static int readerIndexOf(ByteStream part, int partIndex) {
        return part.readerIndex() + partIndex;
    }

    private int partOffset(int streamIndex, int part) {
        return streamIndex - this.userIndex[part];
    }

    private void validateIndexes(int startIndex, int endIndex) {
        if (startIndex < 0 || endIndex < 0) {
            throw new IllegalArgumentException("Start and end indexes must be non-negative.");
        }
        if (startIndex >= this.length || endIndex > this.length) {
            throw new IllegalArgumentException("Start and end indexes must be within the bounds of the stream.");
        }
        if (startIndex > endIndex) {
            throw new IllegalArgumentException("Start index must be less than end index.");
        }
    }

    private int prev(int i) {
        return i - 1 & this.mask;
    }

    private int next(int i) {
        return i + 1 & this.mask;
    }

    private boolean hasMoreParts(int i) {
        return i != this.end && this.userIndex[i] != -1;
    }

    private void releasePart(int i) {
        this.userIndex[i] = -1;
        this.parts[i].release();
        this.parts[i] = null;
    }

    public static interface Consumer<P1, P2>
    extends Serializable {
        public void accept(P1 var1, P2 var2, ByteStream var3, int var4, int var5, boolean var6);
    }
}

