/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers.json;

import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.processor.Transformer;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.ServiceLoadedBuilderProvider;
import io.hyperfoil.core.handlers.json.ByteBufByteStream;
import io.hyperfoil.core.handlers.json.ByteStream;
import io.hyperfoil.core.handlers.json.JsonParser;
import io.hyperfoil.core.handlers.json.JsonUnquotingTransformer;
import io.netty.buffer.ByteBuf;

public class JsonHandler
extends JsonParser
implements Processor,
ResourceUtilizer,
Session.ResourceKey<Context> {
    public JsonHandler(String query, boolean delete, Transformer replace, Processor processor) {
        super(query.trim(), delete, replace, processor);
    }

    public void before(Session session) {
        this.processor.before(session);
        if (this.replace != null) {
            this.replace.before(session);
        }
    }

    public void process(Session session, ByteBuf data, int offset, int length, boolean isLast) {
        if (data.readableBytes() == 0) {
            return;
        }
        Context ctx = (Context)session.getResource((Session.ResourceKey)this);
        ctx.parse(ctx.wrap(data, offset, length), session, isLast);
    }

    public void after(Session session) {
        if (this.replace != null) {
            this.replace.after(session);
        }
        this.processor.after(session);
        Context ctx = (Context)session.getResource((Session.ResourceKey)this);
        ctx.reset();
    }

    public String toString() {
        return "JsonHandler{query='" + this.query + "', recorder=" + String.valueOf(this.processor) + "}";
    }

    public void reserve(Session session) {
        session.declareResource((Session.ResourceKey)this, () -> new Context());
    }

    @Override
    protected void record(JsonParser.Context context, Session session, ByteStream data, int offset, int length, boolean isLastPart) {
        this.processor.process(session, ((ByteBufByteStream)data).buffer(), offset, length, isLastPart);
    }

    public class Context
    extends JsonParser.Context {
        ByteBufByteStream actualStream;

        Context() {
            super(self -> new ByteBufByteStream(null, self::release));
            this.actualStream = new ByteBufByteStream(this::retain, null);
        }

        public ByteStream wrap(ByteBuf data, int offset, int length) {
            return this.actualStream.wrap(data, offset, offset + length);
        }

        @Override
        protected void replaceConsumer(Void ignored, Session session, ByteStream data, int offset, int length, boolean lastFragment) {
            JsonHandler.this.replace.transform(session, ((ByteBufByteStream)data).buffer(), offset, length, lastFragment, this.replaceBuffer);
        }
    }

    @Name(value="json")
    public static class Builder
    extends JsonParser.BaseBuilder<Builder>
    implements Processor.Builder {
        public JsonHandler build(boolean fragmented) {
            Transformer replace;
            Processor processor = this.processors.build(fragmented || this.unquote);
            Transformer transformer = replace = this.replace == null ? null : this.replace.build(fragmented);
            if (this.unquote) {
                processor = new JsonUnquotingTransformer(processor);
                if (replace != null) {
                    replace = new JsonUnquotingTransformer(replace);
                }
            }
            return new JsonHandler(this.query, this.delete, replace, processor);
        }

        public ServiceLoadedBuilderProvider<Processor.Builder> processor() {
            return new ServiceLoadedBuilderProvider<Processor.Builder>(Processor.Builder.class, this.processors::processor);
        }
    }
}

