/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers.json;

import io.hyperfoil.core.handlers.json.ByteStream;
import io.netty.buffer.ByteBuf;
import java.util.function.Consumer;
import java.util.function.Function;

public class ByteBufByteStream
implements ByteStream {
    private final Function<ByteStream, ByteStream> retain;
    private final Consumer<ByteStream> release;
    private ByteBuf buffer;
    private int readerIndex;
    private int writerIndex;

    public ByteBufByteStream(Function<ByteStream, ByteStream> retain, Consumer<ByteStream> release) {
        this.retain = retain;
        this.release = release;
    }

    @Override
    public int getByte(int index) {
        return this.buffer.getByte(index);
    }

    @Override
    public int writerIndex() {
        return this.writerIndex;
    }

    @Override
    public int readerIndex() {
        return this.readerIndex;
    }

    @Override
    public void release() {
        this.buffer.release();
        this.buffer = null;
        this.readerIndex = -1;
        this.release.accept(this);
    }

    @Override
    public ByteStream retain() {
        this.buffer.retain();
        return this.retain.apply(this);
    }

    @Override
    public void moveTo(ByteStream other) {
        ByteBufByteStream o = (ByteBufByteStream)other;
        assert (o.buffer == null);
        o.buffer = this.buffer;
        o.readerIndex = this.readerIndex;
        o.writerIndex = this.writerIndex;
        this.buffer = null;
        this.readerIndex = -1;
    }

    public ByteBuf buffer() {
        return this.buffer;
    }

    public ByteBufByteStream wrap(ByteBuf data, int readerIndex, int writerIndex) {
        this.buffer = data;
        this.readerIndex = readerIndex;
        this.writerIndex = writerIndex;
        return this;
    }
}

