/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers.json;

import io.hyperfoil.core.handlers.json.ByteStream;
import java.util.function.Consumer;
import java.util.function.Function;

public class ByteArrayByteStream
implements ByteStream {
    private final Function<ByteStream, ByteStream> retain;
    private final Consumer<ByteStream> release;
    private byte[] array;
    private int readerIndex;

    public ByteArrayByteStream(Function<ByteStream, ByteStream> retain, Consumer<ByteStream> release) {
        this.retain = retain;
        this.release = release;
    }

    public byte[] array() {
        return this.array;
    }

    @Override
    public int getByte(int index) {
        return this.array[index];
    }

    @Override
    public int writerIndex() {
        return this.array.length;
    }

    @Override
    public int readerIndex() {
        return this.readerIndex;
    }

    @Override
    public void release() {
        this.release.accept(this);
    }

    @Override
    public ByteStream retain() {
        return this.retain.apply(this);
    }

    @Override
    public void moveTo(ByteStream other) {
        ByteArrayByteStream o = (ByteArrayByteStream)other;
        o.array = this.array;
        o.readerIndex = this.readerIndex;
        this.array = null;
    }

    public ByteArrayByteStream wrap(byte[] array) {
        this.array = array;
        this.readerIndex = 0;
        return this;
    }
}

