/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.connection.Request;
import io.hyperfoil.api.processor.RawBytesHandler;
import io.hyperfoil.api.statistics.Statistics;
import io.hyperfoil.api.statistics.StatsExtension;
import io.netty.buffer.ByteBuf;

public class TransferSizeRecorder
implements RawBytesHandler {
    private final String key;

    public TransferSizeRecorder(String key) {
        this.key = key;
    }

    public void onRequest(Request request, ByteBuf buf, int offset, int length) {
        Statistics statistics = request.statistics();
        statistics.update(this.key, request.startTimestampMillis(), Stats::new, (s, l) -> s.sent += l, (long)length);
    }

    public void onResponse(Request request, ByteBuf buf, int offset, int length, boolean isLastPart) {
        Statistics statistics = request.statistics();
        statistics.update(this.key, request.startTimestampMillis(), Stats::new, (s, l) -> s.received += l, (long)length);
    }

    @JsonTypeName(value="transfersize")
    public static class Stats
    implements StatsExtension {
        private static final String[] HEADERS = new String[]{"sent", "received"};
        public long sent;
        public long received;

        public boolean isNull() {
            return this.sent + this.received == 0L;
        }

        public void add(StatsExtension other) {
            if (other instanceof Stats) {
                Stats o = (Stats)other;
                this.sent += o.sent;
                this.received += o.received;
            } else {
                throw new IllegalArgumentException(other.toString());
            }
        }

        public void subtract(StatsExtension other) {
            if (other instanceof Stats) {
                Stats o = (Stats)other;
                this.sent -= o.sent;
                this.received -= o.received;
            } else {
                throw new IllegalArgumentException(other.toString());
            }
        }

        public void reset() {
            this.sent = 0L;
            this.received = 0L;
        }

        public StatsExtension clone() {
            Stats copy = new Stats();
            copy.sent = this.sent;
            copy.received = this.received;
            return copy;
        }

        public String[] headers() {
            return HEADERS;
        }

        public String byHeader(String header) {
            switch (header) {
                case "sent": {
                    return String.valueOf(this.sent);
                }
                case "received": {
                    return String.valueOf(this.received);
                }
            }
            return "<unknown header: " + header + ">";
        }
    }

    @Name(value="transferSizeRecorder")
    public static class Builder
    implements RawBytesHandler.Builder {
        private String key;

        public Builder key(String metric) {
            this.key = metric;
            return this;
        }

        public TransferSizeRecorder build() {
            return new TransferSizeRecorder(this.key);
        }
    }
}

