/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers;

import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.ServiceLoadedBuilderProvider;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class MultiProcessor
implements Processor {
    protected final Processor[] delegates;

    public MultiProcessor(Processor ... delegates) {
        this.delegates = delegates;
    }

    public void before(Session session) {
        for (Processor p : this.delegates) {
            p.before(session);
        }
    }

    public void after(Session session) {
        for (Processor p : this.delegates) {
            p.after(session);
        }
    }

    public void process(Session session, ByteBuf data, int offset, int length, boolean isLastPart) {
        for (Processor p : this.delegates) {
            p.process(session, data, offset, length, isLastPart);
        }
    }

    public static class Builder<P, S extends Builder<P, S>>
    implements Processor.Builder {
        public final P parent;
        public final List<Processor.Builder> delegates = new ArrayList<Processor.Builder>();

        public Builder(P parent) {
            this.parent = parent;
        }

        public Processor build(boolean fragmented) {
            Processor[] delegates = this.buildProcessors(fragmented);
            return new MultiProcessor(delegates);
        }

        protected Processor[] buildProcessors(boolean fragmented) {
            Processor[] delegates = (Processor[])this.delegates.stream().map(d -> d.build(fragmented)).toArray(Processor[]::new);
            return delegates;
        }

        public Processor buildSingle(boolean fragmented) {
            if (this.delegates.size() == 1) {
                return this.delegates.get(0).build(fragmented);
            }
            return new MultiProcessor(this.buildProcessors(fragmented));
        }

        public S processor(Processor.Builder processor) {
            this.delegates.add(processor);
            return this.self();
        }

        public S processors(Collection<? extends Processor.Builder> processors) {
            this.delegates.addAll(processors);
            return this.self();
        }

        public ServiceLoadedBuilderProvider<Processor.Builder> processor() {
            return new ServiceLoadedBuilderProvider<Processor.Builder>(Processor.Builder.class, this::processor);
        }

        protected S self() {
            return (S)this;
        }

        public P end() {
            return this.parent;
        }

        public boolean isEmpty() {
            return this.delegates.isEmpty();
        }
    }
}

