/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers;

import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.connection.Request;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.handlers.MultiProcessor;
import io.hyperfoil.core.session.SessionFactory;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.Unpooled;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.FormattedMessage;
import org.apache.logging.log4j.message.Message;

public class GzipInflatorProcessor
extends MultiProcessor
implements ResourceUtilizer,
Session.ResourceKey<InflaterResource> {
    private static final Logger log = LogManager.getLogger(GzipInflatorProcessor.class);
    private static final int FHCRC = 2;
    private static final int FEXTRA = 4;
    private static final int FNAME = 8;
    private static final int FCOMMENT = 16;
    private final ReadAccess encodingVar;

    public GzipInflatorProcessor(Processor[] processors, ReadAccess encodingVar) {
        super(processors);
        this.encodingVar = encodingVar;
    }

    @Override
    public void process(Session session, ByteBuf data, int offset, int length, boolean isLastPart) {
        Session.Var var = this.encodingVar.getVar(session);
        InflaterResource resource = (InflaterResource)session.getResource((Session.ResourceKey)this);
        switch (resource.state.ordinal()) {
            case 1: {
                super.process(session, data, offset, length, isLastPart);
            }
            case 2: {
                return;
            }
            case 0: {
                if (var.isSet() && "gzip".equalsIgnoreCase(var.objectValue(session).toString())) {
                    resource.state = State.FIRST_4_BYTES;
                    resource.inflater.reset();
                    break;
                }
                resource.state = State.NOT_ENCRYPTED;
                return;
            }
        }
        resource.process(session, data, offset, length);
    }

    public void reserve(Session session) {
        session.declareResource((Session.ResourceKey)this, () -> new InflaterResource());
    }

    public class InflaterResource
    implements Session.Resource {
        private final Inflater inflater = new Inflater(true);
        private State state = State.UNINITIALIZED;
        private final byte[] buf = new byte[512];
        private int bufSize = 0;
        private final ByteBuf output = ByteBufAllocator.DEFAULT.buffer(512);
        private final ByteBuffer nioOutput;

        private InflaterResource() {
            this.output.writerIndex(this.output.capacity());
            assert (this.output.nioBufferCount() == 1);
            this.nioOutput = this.output.nioBuffer();
        }

        public void destroy() {
            this.output.release();
        }

        public void process(Session session, ByteBuf data, int offset, int length) {
            block14: while (length > 0) {
                switch (this.state.ordinal()) {
                    case 2: {
                        return;
                    }
                    case 3: {
                        int read = Math.min(length, 4 - this.bufSize);
                        data.getBytes(offset, this.buf, this.bufSize, read);
                        this.bufSize += read;
                        length -= read;
                        offset += read;
                        if (this.bufSize < 4) continue block14;
                        if (Byte.toUnsignedInt(this.buf[0]) != 31 || Byte.toUnsignedInt(this.buf[1]) != 139) {
                            log.error("#{} Invalid magic bytes at the beginning of the stream", (Object)session.uniqueId());
                            this.invalidate(session);
                            continue block14;
                        }
                        if (Byte.toUnsignedInt(this.buf[2]) != 8) {
                            log.error("#{} Invalid compression method", (Object)session.uniqueId());
                            this.invalidate(session);
                            continue block14;
                        }
                        this.state = State.SKIP_6_BYTES;
                        this.bufSize = 0;
                        continue block14;
                    }
                    case 4: {
                        int read = Math.min(length, 6 - this.bufSize);
                        this.bufSize += read;
                        offset += read;
                        length -= read;
                        if (this.bufSize < 6) continue block14;
                        this.state = State.CHECK_EXTRA_FIELDS;
                        this.bufSize = 0;
                        continue block14;
                    }
                    case 5: {
                        int read;
                        if ((Byte.toUnsignedInt(this.buf[3]) & 4) != 0) {
                            read = Math.min(length, 2 - this.bufSize);
                            data.getBytes(offset, this.buf, 0, read);
                            this.bufSize += read;
                            offset += read;
                            length -= read;
                            if (this.bufSize < 2) continue block14;
                            this.state = State.SKIP_EXTRA_FIELDS;
                            this.bufSize = Byte.toUnsignedInt(this.buf[1]) << 8 | Byte.toUnsignedInt(this.buf[0]);
                            continue block14;
                        }
                        this.state = State.SKIP_FILENAME;
                        continue block14;
                    }
                    case 6: {
                        int read = Math.min(length, this.bufSize);
                        offset += read;
                        length -= read;
                        this.bufSize -= read;
                        if (this.bufSize != 0) continue block14;
                        this.state = State.SKIP_FILENAME;
                        continue block14;
                    }
                    case 7: {
                        if ((Byte.toUnsignedInt(this.buf[3]) & 8) != 0) {
                            if (!this.skipZeroTerminated(data, offset, length)) continue block14;
                            this.state = State.SKIP_COMMENT;
                            continue block14;
                        }
                        this.state = State.SKIP_COMMENT;
                        continue block14;
                    }
                    case 8: {
                        if ((Byte.toUnsignedInt(this.buf[3]) & 0x10) != 0) {
                            if (!this.skipZeroTerminated(data, offset, length)) continue block14;
                            this.state = State.CHECK_HEADER_CRC;
                            continue block14;
                        }
                        this.state = State.CHECK_HEADER_CRC;
                        continue block14;
                    }
                    case 9: {
                        int read;
                        if ((Byte.toUnsignedInt(this.buf[3]) & 2) != 0) {
                            read = Math.min(length, 2 - this.bufSize);
                            this.bufSize += read;
                            offset += read;
                            length -= read;
                            if (this.bufSize < 2) continue block14;
                            this.state = State.DATA;
                            continue block14;
                        }
                        this.state = State.DATA;
                        continue block14;
                    }
                    case 10: {
                        int read;
                        try {
                            int n;
                            while ((n = this.inflater.inflate(this.nioOutput)) == 0) {
                                if (this.inflater.needsDictionary()) {
                                    log.error("#{} decompression requires a pre-set dictionary but it is not available.", (Object)session.uniqueId());
                                    this.invalidate(session);
                                    break;
                                }
                                if (this.inflater.finished()) {
                                    offset -= this.inflater.getRemaining();
                                    length += this.inflater.getRemaining();
                                    this.inflater.reset();
                                    GzipInflatorProcessor.super.process(session, Unpooled.EMPTY_BUFFER, 0, 0, true);
                                    this.state = State.EOF;
                                    this.bufSize = 8;
                                    break;
                                }
                                if (!this.inflater.needsInput()) continue;
                                if (length == 0) break;
                                read = Math.min(this.buf.length, length);
                                data.getBytes(offset, this.buf, 0, read);
                                offset += read;
                                length -= read;
                                this.inflater.setInput(this.buf, 0, read);
                            }
                            if (n == 0) continue block14;
                            this.nioOutput.position(0).limit(this.output.capacity());
                            boolean finished = this.inflater.finished();
                            GzipInflatorProcessor.super.process(session, this.output, 0, n, finished);
                            if (!finished) continue block14;
                            offset -= this.inflater.getRemaining();
                            length += this.inflater.getRemaining();
                            this.inflater.reset();
                            this.state = State.EOF;
                            this.bufSize = 8;
                        }
                        catch (DataFormatException e) {
                            log.error((Message)new FormattedMessage("#{} Failed to decompress GZIPed data.", (Object)session.uniqueId()), (Throwable)e);
                            this.invalidate(session);
                        }
                        continue block14;
                    }
                    case 11: {
                        int read = Math.min(length, this.bufSize);
                        offset += read;
                        length -= read;
                        this.bufSize -= read;
                        if (this.bufSize != 0) continue block14;
                        this.state = State.FIRST_4_BYTES;
                        continue block14;
                    }
                }
                throw new IllegalStateException(this.state.toString());
            }
        }

        private void invalidate(Session session) {
            Request request = session.currentRequest();
            if (request != null) {
                request.markInvalid();
            }
            this.state = State.INVALID;
        }

        private boolean skipZeroTerminated(ByteBuf data, int offset, int length) {
            byte b;
            do {
                b = data.getByte(offset);
                ++offset;
            } while (b != 0 && --length > 0);
            return b == 0;
        }
    }

    private static enum State {
        UNINITIALIZED,
        NOT_ENCRYPTED,
        INVALID,
        FIRST_4_BYTES,
        SKIP_6_BYTES,
        CHECK_EXTRA_FIELDS,
        SKIP_EXTRA_FIELDS,
        SKIP_FILENAME,
        SKIP_COMMENT,
        CHECK_HEADER_CRC,
        DATA,
        EOF;

    }

    @Name(value="gzipInflator")
    public static class Builder
    extends MultiProcessor.Builder<Void, Builder>
    implements Processor.Builder {
        private Object encodingVar;

        public Builder() {
            super(null);
        }

        @Override
        public Processor build(boolean fragmented) {
            Processor[] processors = this.buildProcessors(fragmented);
            return new GzipInflatorProcessor(processors, SessionFactory.readAccess(this.encodingVar));
        }

        public Builder encodingVar(Object var) {
            this.encodingVar = var;
            return this;
        }
    }
}

