/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.handlers;

import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.ObjectAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.data.DataFormat;
import io.hyperfoil.core.handlers.DefragProcessor;
import io.hyperfoil.core.session.SessionFactory;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;

public class CollectionRecorder
implements Processor {
    private final ObjectAccess toVar;
    private final DataFormat format;

    public CollectionRecorder(ObjectAccess toVar, DataFormat format) {
        this.toVar = toVar;
        this.format = format;
    }

    public void process(Session session, ByteBuf data, int offset, int length, boolean isLastPart) {
        List<Object> list;
        this.ensureDefragmented(isLastPart);
        if (!this.toVar.isSet(session)) {
            list = new ArrayList<Object>();
            this.toVar.setObject(session, list);
        } else {
            Object obj = this.toVar.getObject(session);
            if (obj instanceof List) {
                list = (List)obj;
            } else {
                list = new ArrayList();
                this.toVar.setObject(session, list);
            }
        }
        list.add(this.format.convert(data, offset, length));
    }

    @Name(value="collection")
    public static class Builder
    implements Processor.Builder,
    InitFromParam<Builder> {
        private String toVar;
        private DataFormat format = DataFormat.STRING;

        public Builder init(String param) {
            return this.toVar(param);
        }

        public Builder toVar(String var) {
            this.toVar = var;
            return this;
        }

        public Builder format(DataFormat format) {
            this.format = format;
            return this;
        }

        public Processor build(boolean fragmented) {
            return DefragProcessor.of(new CollectionRecorder(SessionFactory.objectAccess(this.toVar), this.format), fragmented);
        }
    }
}

