/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.generators;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.ObjectAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.BaseStepBuilder;
import io.hyperfoil.core.generators.Pattern;
import io.hyperfoil.core.session.SessionFactory;
import java.util.Collections;
import java.util.List;

public class TemplateStep
implements Step {
    private final Pattern pattern;
    private final ObjectAccess toVar;

    public TemplateStep(Pattern pattern, ObjectAccess toVar) {
        this.pattern = pattern;
        this.toVar = toVar;
    }

    public boolean invoke(Session session) {
        this.toVar.setObject(session, (Object)this.pattern.apply(session));
        return true;
    }

    @Name(value="template")
    public static class Builder
    extends BaseStepBuilder<Builder> {
        private String pattern;
        private String toVar;

        public Builder pattern(String pattern) {
            this.pattern = pattern;
            return this;
        }

        public Builder toVar(String var) {
            this.toVar = var;
            return this;
        }

        public List<Step> build() {
            if (this.pattern == null) {
                throw new BenchmarkDefinitionException("Missing pattern for template.");
            }
            if (this.toVar == null) {
                throw new BenchmarkDefinitionException("Missing target var for template.");
            }
            return Collections.singletonList(new TemplateStep(new Pattern(this.pattern, false), SessionFactory.objectAccess(this.toVar)));
        }
    }
}

