/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.generators;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.generators.Pattern;
import io.hyperfoil.core.generators.StringGeneratorBuilder;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.function.SerializableFunction;
import java.io.Serializable;
import java.util.function.Supplier;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StringGeneratorImplBuilder<T>
implements StringGeneratorBuilder,
InitFromParam<StringGeneratorImplBuilder<T>> {
    private static final Logger log = LogManager.getLogger(StringGeneratorImplBuilder.class);
    private final T parent;
    private Supplier<SerializableFunction<Session, String>> supplier;

    public StringGeneratorImplBuilder(T parent) {
        this.parent = parent;
    }

    public StringGeneratorImplBuilder<T> init(String param) {
        return this.pattern(param);
    }

    private void set(Supplier<SerializableFunction<Session, String>> function) {
        if (this.supplier != null) {
            throw new BenchmarkDefinitionException("Specify only one of: value, var, pattern");
        }
        this.supplier = function;
    }

    public StringGeneratorImplBuilder<T> value(String value) {
        this.set(() -> (SerializableFunction & Serializable)session -> value);
        return this;
    }

    public StringGeneratorImplBuilder<T> fromVar(Object var) {
        if (var == null) {
            throw new BenchmarkDefinitionException("Variable must not be null");
        }
        this.set(() -> {
            ReadAccess access = SessionFactory.readAccess(var);
            assert (access != null);
            return (SerializableFunction & Serializable)session -> {
                Object value = access.getObject(session);
                if (value instanceof String) {
                    return (String)value;
                }
                log.error("Cannot retrieve string from {}, the content is {}", var, value);
                return null;
            };
        });
        return this;
    }

    public StringGeneratorImplBuilder<T> pattern(String pattern) {
        this.set(() -> new Pattern(pattern, false));
        return this;
    }

    public T end() {
        return this.parent;
    }

    @Override
    public SerializableFunction<Session, String> build() {
        return this.supplier.get();
    }
}

