/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.generators;

import io.hyperfoil.api.config.BenchmarkData;
import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Locator;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.config.StepBuilder;
import io.hyperfoil.api.session.ObjectAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.generators.WeightedGenerator;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.impl.Util;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class RandomFileStep
implements Step {
    private final WeightedGenerator generator;
    private final byte[][] fileBytes;
    private final ObjectAccess toVar;
    private final ObjectAccess filenameVar;

    public RandomFileStep(WeightedGenerator generator, byte[][] fileBytes, ObjectAccess toVar, ObjectAccess filenameVar) {
        this.generator = generator;
        this.fileBytes = fileBytes;
        this.toVar = toVar;
        this.filenameVar = filenameVar;
    }

    public boolean invoke(Session session) {
        int index = this.generator.randomIndex();
        this.toVar.setObject(session, (Object)this.fileBytes[index]);
        if (this.filenameVar != null) {
            this.filenameVar.setObject(session, (Object)this.generator.items()[index]);
        }
        return true;
    }

    @Name(value="randomFile")
    public static class Builder
    implements StepBuilder<Builder> {
        private String toVar;
        private WeightedGenerator.Builder<Builder> weighted = new WeightedGenerator.Builder<Builder>(this);
        private String filenameVar;

        public WeightedGenerator.Builder<Builder> files() {
            return this.weighted;
        }

        public Builder toVar(String var) {
            this.toVar = var;
            return this;
        }

        public Builder filenameVar(String var) {
            this.filenameVar = var;
            return this;
        }

        public List<Step> build() {
            WeightedGenerator generator = this.weighted.build();
            BenchmarkData data = Locator.current().benchmark().data();
            ArrayList<byte[]> fileBytes = new ArrayList<byte[]>();
            for (String file : generator.items()) {
                try {
                    fileBytes.add(Util.toByteArray((InputStream)data.readFile(file)));
                }
                catch (IOException e) {
                    throw new BenchmarkDefinitionException("Cannot read bytes from file " + file);
                }
            }
            return Collections.singletonList(new RandomFileStep(generator, (byte[][])fileBytes.toArray((T[])new byte[0][]), SessionFactory.objectAccess(this.toVar), SessionFactory.objectAccess(this.filenameVar)));
        }
    }
}

