/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.generators;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Locator;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.PairBuilder;
import io.hyperfoil.api.config.Step;
import io.hyperfoil.api.session.ObjectAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.BaseStepBuilder;
import io.hyperfoil.core.session.SessionFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.IntUnaryOperator;

public class RandomCsvRowStep
implements Step {
    private final String[][] rows;
    private final ObjectAccess[] columnVars;
    private final transient IntUnaryOperator rowSelector;

    public RandomCsvRowStep(String[][] rows, ObjectAccess[] columnVars, IntUnaryOperator rowSelector) {
        this.rows = rows;
        this.columnVars = columnVars;
        this.rowSelector = rowSelector;
    }

    String[][] rows() {
        return this.rows;
    }

    IntUnaryOperator rowSelector() {
        return this.rowSelector;
    }

    public boolean invoke(Session session) {
        if (this.rows.length == 0) {
            throw new RuntimeException("No rows available - was the CSV file empty?");
        }
        IntUnaryOperator rowSelector = this.rowSelector;
        int rndRow = rowSelector == null ? ThreadLocalRandom.current().nextInt(this.rows.length) : rowSelector.applyAsInt(this.rows.length);
        String[] row = this.rows[rndRow];
        ObjectAccess[] columnVars = this.columnVars;
        for (int i = 0; i < columnVars.length; ++i) {
            columnVars[i].setObject(session, (Object)row[i]);
        }
        return true;
    }

    @Name(value="randomCsvRow")
    public static class Builder
    extends BaseStepBuilder<Builder> {
        private String file;
        private boolean skipComments;
        private char separator = (char)44;
        private final List<String> builderColumns = new ArrayList<String>();
        private transient IntUnaryOperator customRowSelector = null;

        public List<Step> build() {
            List<Step> list;
            block24: {
                int[] srcIndex = new int[(int)this.builderColumns.stream().filter(Objects::nonNull).count()];
                int next = 0;
                for (int i2 = 0; i2 < this.builderColumns.size(); ++i2) {
                    if (this.builderColumns.get(i2) == null) continue;
                    srcIndex[next++] = i2;
                }
                assert (next == srcIndex.length);
                InputStream inputStream = Locator.current().benchmark().data().readFile(this.file);
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));
                    ArrayList<String[]> records = new ArrayList<String[]>();
                    ArrayList<String> currentRecord = new ArrayList<String>();
                    StringBuilder sb = new StringBuilder();
                    boolean quoted = false;
                    boolean maybeClosingQuote = false;
                    int lineNumber = 1;
                    while ((line = reader.readLine()) != null) {
                        if (!quoted && this.skipComments && line.stripLeading().startsWith("#")) continue;
                        for (int i3 = 0; i3 < line.length(); ++i3) {
                            char c = line.charAt(i3);
                            if (!quoted) {
                                if (c == this.separator) {
                                    currentRecord.add(sb.toString());
                                    sb.setLength(0);
                                    continue;
                                }
                                if (c == '\"') {
                                    if (sb.length() != 0) {
                                        throw new BenchmarkDefinitionException("The CSV file " + this.file + " is invalid; line " + lineNumber + " uses quote but it's quoting correctly (check preceding whitespaces?)");
                                    }
                                    quoted = true;
                                    continue;
                                }
                                sb.append(c);
                                continue;
                            }
                            if (i3 == 0) {
                                assert (lineNumber > 1);
                                sb.append('\n');
                            }
                            if (c == '\"') {
                                if (maybeClosingQuote) {
                                    sb.append(c);
                                    maybeClosingQuote = false;
                                    continue;
                                }
                                maybeClosingQuote = true;
                                continue;
                            }
                            if (maybeClosingQuote) {
                                quoted = false;
                                maybeClosingQuote = false;
                                if (c == this.separator) {
                                    currentRecord.add(sb.toString());
                                    sb.setLength(0);
                                    continue;
                                }
                                throw new BenchmarkDefinitionException("The CSV file " + this.file + " is invalid; line " + lineNumber + " uses quote but it's quoting correctly (check characters after?)");
                            }
                            sb.append(c);
                        }
                        if (maybeClosingQuote) {
                            quoted = false;
                            maybeClosingQuote = false;
                        }
                        if (!quoted) {
                            currentRecord.add(sb.toString());
                            sb.setLength(0);
                            String[] arr = new String[srcIndex.length];
                            Arrays.setAll(arr, i -> srcIndex[i] < currentRecord.size() ? (String)currentRecord.get(srcIndex[i]) : null);
                            currentRecord.clear();
                            records.add(arr);
                        }
                        ++lineNumber;
                    }
                    String[][] rows = (String[][])records.toArray((T[])new String[0][]);
                    ObjectAccess[] columnVars = (ObjectAccess[])this.builderColumns.stream().filter(Objects::nonNull).map(SessionFactory::objectAccess).toArray(ObjectAccess[]::new);
                    list = Collections.singletonList(new RandomCsvRowStep(rows, columnVars, this.customRowSelector));
                    if (inputStream == null) break block24;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException ioe) {
                        throw new BenchmarkDefinitionException("Failed to read file " + this.file, (Throwable)ioe);
                    }
                }
                inputStream.close();
            }
            return list;
        }

        Builder customSelector(IntUnaryOperator selector) {
            this.customRowSelector = Objects.requireNonNull(selector);
            return this;
        }

        public ColumnsBuilder columns() {
            return new ColumnsBuilder();
        }

        public Builder file(String file) {
            this.file = file;
            return this;
        }

        public Builder skipComments(boolean skipComments) {
            this.skipComments = skipComments;
            return this;
        }

        @Deprecated
        public Builder removeQuotes(boolean removeQuotes) {
            return this;
        }

        public Builder separator(char separator) {
            this.separator = separator;
            return this;
        }

        public class ColumnsBuilder
        extends PairBuilder.OfString {
            public void accept(String position, String columnVar) {
                int pos = Integer.parseInt(position);
                if (pos < 0) {
                    throw new BenchmarkDefinitionException("Negative column index is not supported.");
                }
                while (pos >= Builder.this.builderColumns.size()) {
                    Builder.this.builderColumns.add(null);
                }
                String prev = Builder.this.builderColumns.set(pos, columnVar);
                if (prev != null) {
                    throw new BenchmarkDefinitionException("Column " + pos + " is already mapped to '" + prev + "', don't map to '" + columnVar + "'");
                }
            }
        }
    }
}

