/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.data;

import io.hyperfoil.api.session.GlobalData;
import java.util.HashMap;
import java.util.Map;

public class GlobalCounters
implements GlobalData.Element {
    private final Map<String, Long> counters;

    public GlobalCounters(Map<String, Long> counters) {
        this.counters = counters;
    }

    public long get(String counter) {
        return this.counters.getOrDefault(counter, 0L);
    }

    public Map<String, Long> getAll() {
        return this.counters;
    }

    public GlobalData.Accumulator newAccumulator() {
        return new Accumulator();
    }

    public String toString() {
        return this.counters.toString();
    }

    private static class Accumulator
    implements GlobalData.Accumulator {
        private final Map<String, Long> counters = new HashMap<String, Long>();

        private Accumulator() {
        }

        public void add(GlobalData.Element e) {
            if (e instanceof GlobalCounters) {
                GlobalCounters gc = (GlobalCounters)e;
                for (Map.Entry<String, Long> entry : gc.counters.entrySet()) {
                    Long newValue = this.counters.getOrDefault(entry.getKey(), 0L) + entry.getValue();
                    this.counters.put(entry.getKey(), newValue);
                }
            } else {
                throw new IllegalArgumentException("Expected GlobalCounters, got: " + String.valueOf(e));
            }
        }

        public GlobalData.Element complete() {
            return new GlobalCounters(this.counters);
        }
    }
}

