/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.builders;

import io.hyperfoil.api.session.Session;
import io.hyperfoil.function.SerializableBiPredicate;
import java.io.Serializable;

public abstract class StringConditionBase
implements Serializable {
    protected final SerializableBiPredicate<Session, CharSequence> predicate;

    public StringConditionBase(SerializableBiPredicate<Session, CharSequence> predicate) {
        this.predicate = predicate;
    }

    public boolean testVar(Session session, Session.Var var) {
        if (this.predicate == null) {
            return true;
        }
        if (var.type() == Session.VarType.INTEGER) {
            String value = String.valueOf(var.intValue(session));
            return this.predicate.test((Object)session, (Object)value);
        }
        if (var.type() == Session.VarType.OBJECT) {
            Object obj = var.objectValue(session);
            return this.testObject(session, obj);
        }
        throw new IllegalStateException("Unknown type of var: " + String.valueOf(var));
    }

    public boolean testObject(Session session, Object obj) {
        if (!(obj instanceof CharSequence)) {
            return false;
        }
        return this.predicate.test((Object)session, (Object)((CharSequence)obj));
    }
}

