/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.builders;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.BuilderBase;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.session.ObjectAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.function.SerializableFunction;
import java.util.Objects;
import java.util.stream.Stream;

public class ObjectSourceBuilder<P>
implements BuilderBase<ObjectSourceBuilder<P>>,
InitFromParam<ObjectSourceBuilder<P>> {
    private final P parent;
    private String value;
    private String fromVar;

    public ObjectSourceBuilder(P parent) {
        this.parent = parent;
    }

    public ObjectSourceBuilder<P> init(String param) {
        return this.value(param);
    }

    public ObjectSourceBuilder<P> value(String value) {
        this.value = value;
        return this;
    }

    public ObjectSourceBuilder<P> fromVar(String fromVar) {
        this.fromVar = fromVar;
        return this;
    }

    public P end() {
        return this.parent;
    }

    public SerializableFunction<Session, Object> build() {
        if (Stream.of(this.value, this.fromVar).filter(Objects::nonNull).count() != 1L) {
            throw new BenchmarkDefinitionException("Must set either 'value' or 'fromVar'");
        }
        if (this.fromVar != null) {
            return new ValueFromVar(SessionFactory.objectAccess(this.fromVar));
        }
        return new ProvidedValue(this.value);
    }

    private static class ValueFromVar
    implements SerializableFunction<Session, Object> {
        private final ObjectAccess fromVar;

        private ValueFromVar(ObjectAccess fromVar) {
            this.fromVar = Objects.requireNonNull(fromVar);
        }

        public Object apply(Session session) {
            return this.fromVar.getObject(session);
        }
    }

    private static class ProvidedValue
    implements SerializableFunction<Session, Object> {
        private final Object value;

        private ProvidedValue(Object value) {
            this.value = value;
        }

        public Object apply(Session session) {
            return this.value;
        }
    }
}

