/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.builders;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.BuilderBase;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.AllConditions;
import io.hyperfoil.core.builders.BoolCondition;
import io.hyperfoil.core.builders.IntCondition;
import io.hyperfoil.core.builders.StringCondition;
import io.hyperfoil.function.SerializablePredicate;

public interface Condition
extends SerializablePredicate<Session> {

    public static class TypesBuilder<P>
    implements Builder<TypesBuilder<P>> {
        private final P parent;
        private IntCondition.Builder<P> intCondition;
        private StringCondition.Builder<P> stringCondition;
        private BoolCondition.Builder<P> boolCondition;
        private AllConditions.Builder<P> allConditions;

        public TypesBuilder() {
            this(null);
        }

        public TypesBuilder(P parent) {
            this.parent = parent;
        }

        private void ensureNotSet() {
            if (this.intCondition != null || this.stringCondition != null || this.boolCondition != null) {
                throw new BenchmarkDefinitionException("This builder can host only single condition type!");
            }
        }

        public IntCondition.Builder<P> intCondition() {
            this.ensureNotSet();
            this.intCondition = new IntCondition.Builder<P>(this.parent);
            return this.intCondition;
        }

        public StringCondition.Builder<P> stringCondition() {
            this.ensureNotSet();
            this.stringCondition = new StringCondition.Builder<P>(this.parent);
            return this.stringCondition;
        }

        public BoolCondition.Builder<P> boolCondition() {
            this.ensureNotSet();
            this.boolCondition = new BoolCondition.Builder<P>(this.parent);
            return this.boolCondition;
        }

        public AllConditions.Builder<P> allConditions() {
            this.ensureNotSet();
            this.allConditions = new AllConditions.Builder<P>(this.parent);
            return this.allConditions;
        }

        @Override
        public Condition buildCondition() {
            if (this.intCondition != null) {
                return this.intCondition.buildCondition();
            }
            if (this.stringCondition != null) {
                return this.stringCondition.buildCondition();
            }
            if (this.boolCondition != null) {
                return this.boolCondition.buildCondition();
            }
            if (this.allConditions != null) {
                return this.allConditions.buildCondition();
            }
            return null;
        }
    }

    public static interface Builder<B extends Builder<B>>
    extends BuilderBase<B> {
        public Condition buildCondition();
    }
}

