/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.builders;

import io.hyperfoil.api.session.Session;
import io.hyperfoil.impl.Util;
import java.io.Serializable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class BoolConditionBase
implements Serializable {
    private static final Logger log = LogManager.getLogger(BoolConditionBase.class);
    protected final boolean value;

    public BoolConditionBase(boolean value) {
        this.value = value;
    }

    public boolean testVar(Session session, Session.Var var) {
        if (!var.isSet()) {
            return false;
        }
        if (var.type() == Session.VarType.INTEGER) {
            return false;
        }
        if (var.type() == Session.VarType.OBJECT) {
            Object obj = var.objectValue(session);
            return this.testObject(obj);
        }
        throw new IllegalStateException("Unknown type of var: " + String.valueOf(var));
    }

    public boolean testObject(Object obj) {
        if (obj instanceof Boolean) {
            log.trace("Test boolean {} == {}", obj, (Object)this.value);
            return (Boolean)obj == this.value;
        }
        if (obj instanceof CharSequence) {
            CharSequence str = (CharSequence)obj;
            log.trace("Test string {} equals {}", (Object)str, (Object)this.value);
            if (this.value) {
                return Util.regionMatchesIgnoreCase((CharSequence)str, (int)0, (CharSequence)"true", (int)0, (int)4);
            }
            return Util.regionMatchesIgnoreCase((CharSequence)str, (int)0, (CharSequence)"false", (int)0, (int)5);
        }
        return false;
    }
}

