/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.core.builders;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.BuilderBase;
import io.hyperfoil.api.config.MappingListBuilder;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.Condition;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class AllConditions
implements Condition {
    private final Condition[] conditions;

    public AllConditions(Condition[] conditions) {
        assert (conditions != null);
        assert (conditions.length > 0);
        this.conditions = conditions;
    }

    public boolean test(Session session) {
        for (Condition c : this.conditions) {
            if (c.test(session)) continue;
            return false;
        }
        return true;
    }

    public static class Builder<P>
    implements MappingListBuilder<Condition.Builder<?>>,
    BuilderBase<Builder<P>>,
    Condition.Builder<Builder<P>> {
        private final P parent;
        private final List<Condition.TypesBuilder<Builder<P>>> list = new ArrayList<Condition.TypesBuilder<Builder<P>>>();

        public Builder() {
            this(null);
        }

        public Builder(P parent) {
            this.parent = parent;
        }

        public Condition.TypesBuilder<Builder<P>> addItem() {
            Condition.TypesBuilder<Builder<P>> builder = new Condition.TypesBuilder<Builder<P>>(this);
            this.list.add(builder);
            return builder;
        }

        public P end() {
            return this.parent;
        }

        @Override
        public AllConditions buildCondition() {
            if (this.list.isEmpty()) {
                throw new BenchmarkDefinitionException("Condition list is empty!");
            }
            return new AllConditions((Condition[])this.list.stream().map(Condition.TypesBuilder::buildCondition).filter(Objects::nonNull).toArray(Condition[]::new));
        }
    }
}

