/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commons.util;

import java.time.Instant;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import net.jcip.annotations.GuardedBy;
import net.jcip.annotations.ThreadSafe;
import org.infinispan.commons.logging.Log;
import org.infinispan.commons.logging.LogFactory;
import org.infinispan.commons.time.TimeService;

@ThreadSafe
public final class ProgressTracker {
    private static final Log log = LogFactory.getLog("LIFECYCLE");
    private final String name;
    private final ScheduledExecutorService executor;
    private final TimeService timeService;
    private final long delay;
    private final TimeUnit unit;
    private final State state;

    public ProgressTracker(String name, ScheduledExecutorService executor, TimeService timeService, long delay, TimeUnit unit) {
        this.name = name;
        this.executor = executor;
        this.timeService = timeService;
        this.state = new State();
        this.delay = delay;
        this.unit = unit;
    }

    public void addTasks(long value) {
        this.state.addTasks(value);
    }

    public void removeTasks(long value) {
        this.state.addTasks(-value);
    }

    public void finishedAllTasks() {
        this.state.completed();
    }

    public long pendingTasks() {
        return this.state.pending();
    }

    public Progression currentTaskStatus() {
        return this.state.status();
    }

    @ThreadSafe
    private final class State
    implements Runnable {
        private final Lock lock = new ReentrantLock();
        private long pending;
        private long lastCheck;
        private Progression status = Progression.IDLE;
        private Instant startedAt = null;
        private ScheduledFuture<?> progression;

        private State() {
        }

        public long pending() {
            this.lock.lock();
            try {
                long l = this.pending;
                return l;
            }
            finally {
                this.lock.unlock();
            }
        }

        public Progression status() {
            this.lock.lock();
            try {
                Progression progression = this.status;
                return progression;
            }
            finally {
                this.lock.unlock();
            }
        }

        public void addTasks(long value) {
            this.lock.lock();
            try {
                if (value < 0L) {
                    if (this.startedAt == null) {
                        throw new IllegalStateException("Removing tasks from a completed tracker: " + ProgressTracker.this.name);
                    }
                    this.status = Progression.PROGRESSING;
                }
                if (this.status == Progression.IDLE || this.status == Progression.DONE) {
                    this.startedAt = ProgressTracker.this.timeService.instant();
                    this.status = Progression.IDLE;
                }
                this.pending += value;
                if (this.progression == null) {
                    this.progression = ProgressTracker.this.executor.scheduleAtFixedRate(ProgressTracker.this.state, ProgressTracker.this.delay, ProgressTracker.this.delay, ProgressTracker.this.unit);
                }
            }
            finally {
                this.lock.unlock();
            }
        }

        public void completed() {
            this.lock.lock();
            try {
                this.status = Progression.DONE;
                if (this.startedAt != null) {
                    log.taskDone(ProgressTracker.this.name, this.startedAt, ProgressTracker.this.timeService.instant());
                }
                this.reset();
            }
            finally {
                this.lock.unlock();
            }
        }

        @GuardedBy(value="lock")
        private void reset() {
            this.pending = 0L;
            this.lastCheck = -1L;
            this.startedAt = null;
            if (this.progression != null) {
                this.progression.cancel(true);
                this.progression = null;
            }
        }

        @Override
        public void run() {
            this.lock.lock();
            try {
                if (this.status == Progression.DONE) {
                    return;
                }
                if (this.lastCheck == this.pending) {
                    this.status = Progression.HANG;
                }
                log.taskProgression(ProgressTracker.this.name, this.pending, this.lastCheck, this.status.name());
                this.lastCheck = this.pending;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public static enum Progression {
        IDLE,
        PROGRESSING,
        HANG,
        DONE;

    }
}

