/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.steps;

import io.hyperfoil.api.config.SLA;
import io.hyperfoil.api.config.Visitor;
import io.hyperfoil.api.connection.Connection;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.steps.StatisticsStep;
import io.hyperfoil.function.SerializableBiConsumer;
import io.hyperfoil.function.SerializableBiFunction;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.HttpRequestWriter;
import io.hyperfoil.http.steps.HttpRequestContext;
import io.netty.buffer.ByteBuf;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SendHttpRequestStep
extends StatisticsStep
implements SLA.Provider {
    private static final Logger log = LogManager.getLogger(SendHttpRequestStep.class);
    private static final boolean trace = log.isTraceEnabled();
    final HttpRequestContext.Key contextKey;
    final SerializableBiFunction<Session, Connection, ByteBuf> bodyGenerator;
    final SerializableBiConsumer<Session, HttpRequestWriter>[] headerAppenders;
    @Visitor.Ignore
    private final boolean injectHostHeader;
    final long timeout;
    final SLA[] sla;

    public SendHttpRequestStep(int stepId, HttpRequestContext.Key contextKey, SerializableBiFunction<Session, Connection, ByteBuf> bodyGenerator, SerializableBiConsumer<Session, HttpRequestWriter>[] headerAppenders, boolean injectHostHeader, long timeout, SLA[] sla) {
        super(stepId);
        this.contextKey = contextKey;
        this.bodyGenerator = bodyGenerator;
        this.headerAppenders = headerAppenders;
        this.injectHostHeader = injectHostHeader;
        this.timeout = timeout;
        this.sla = sla;
    }

    public boolean invoke(Session session) {
        HttpRequestContext context = (HttpRequestContext)session.getResource((Session.ResourceKey)this.contextKey);
        if (!context.ready) {
            context.startWaiting();
            return false;
        }
        if (context.connection == null) {
            log.error("#{} Stopping the session as we cannot obtain connection.", (Object)session.uniqueId());
            session.stop();
            return false;
        }
        context.stopWaiting();
        HttpRequest request = context.request;
        request.send(context.connection, (BiConsumer<Session, HttpRequestWriter>[])this.headerAppenders, this.injectHostHeader, (BiFunction<Session, Connection, ByteBuf>)this.bodyGenerator);
        context.reset();
        request.statistics().incrementRequests(request.startTimestampMillis());
        if (request.isCompleted()) {
            request.release();
            return true;
        }
        if (this.timeout > 0L) {
            request.setTimeout(this.timeout, TimeUnit.MILLISECONDS);
        } else {
            long timeout = request.connection().config().requestTimeout();
            if (timeout > 0L) {
                request.setTimeout(timeout, TimeUnit.MILLISECONDS);
            }
        }
        if (trace) {
            log.trace("#{} sent to {} request on {}", (Object)session.uniqueId(), (Object)request.path, (Object)request.connection());
        }
        return true;
    }

    public SLA[] sla() {
        return this.sla;
    }
}

