/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.steps;

import io.hyperfoil.api.session.Session;
import io.hyperfoil.http.api.ConnectionConsumer;
import io.hyperfoil.http.api.HttpConnection;
import io.hyperfoil.http.api.HttpRequest;

class HttpRequestContext
implements Session.Resource,
ConnectionConsumer {
    HttpRequest request;
    HttpConnection connection;
    boolean ready;
    long waitTimestamp = Long.MIN_VALUE;

    HttpRequestContext() {
    }

    public void onSessionReset(Session session) {
        this.reset();
    }

    public HttpConnection connection() {
        return this.connection;
    }

    public void reset() {
        this.request = null;
        this.connection = null;
        this.ready = false;
        this.waitTimestamp = Long.MIN_VALUE;
    }

    @Override
    public void accept(HttpConnection connection) {
        assert (this.request.session.executor().inEventLoop());
        this.connection = connection;
        this.ready = true;
        this.request.session.proceed();
    }

    public void startWaiting() {
        if (this.waitTimestamp == Long.MIN_VALUE) {
            this.waitTimestamp = System.nanoTime();
        }
    }

    public void stopWaiting() {
        if (this.waitTimestamp != Long.MIN_VALUE) {
            long blockedTime = System.nanoTime() - this.waitTimestamp;
            this.request.statistics().incrementBlockedTime(this.request.startTimestampMillis(), blockedTime);
        }
    }

    public static final class Key
    implements Session.ResourceKey<HttpRequestContext> {
    }
}

