/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.steps;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Locator;
import io.hyperfoil.api.connection.Connection;
import io.hyperfoil.api.session.ReadAccess;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.generators.Pattern;
import io.hyperfoil.core.session.SessionFactory;
import io.hyperfoil.core.util.ConstantBytesGenerator;
import io.hyperfoil.core.util.FromVarBytesGenerator;
import io.hyperfoil.function.SerializableBiFunction;
import io.hyperfoil.http.steps.FormGenerator;
import io.hyperfoil.http.steps.HttpRequestStepBuilder;
import io.hyperfoil.impl.Util;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;

public class BodyBuilder {
    private final HttpRequestStepBuilder parent;

    public BodyBuilder(HttpRequestStepBuilder parent) {
        this.parent = parent;
    }

    public BodyBuilder fromVar(String var) {
        this.parent.body(() -> {
            ReadAccess access = SessionFactory.readAccess((Object)var);
            return new FromVarBytesGenerator(access);
        });
        return this;
    }

    public BodyBuilder pattern(String pattern) {
        this.parent.body(() -> new Pattern(pattern, false).generator());
        return this;
    }

    public BodyBuilder text(String text) {
        this.parent.body((SerializableBiFunction<Session, Connection, ByteBuf>)new ConstantBytesGenerator(text.getBytes(StandardCharsets.UTF_8)));
        return this;
    }

    public FormGenerator.Builder form() {
        FormGenerator.Builder builder = new FormGenerator.Builder();
        this.parent.headerAppender(new FormGenerator.ContentTypeWriter());
        this.parent.body(builder);
        return builder;
    }

    public BodyBuilder fromFile(String path) {
        this.parent.body(() -> {
            ConstantBytesGenerator constantBytesGenerator;
            block9: {
                InputStream inputStream = Locator.current().benchmark().data().readFile(path);
                try {
                    if (inputStream == null) {
                        throw new BenchmarkDefinitionException("Cannot load file `" + path + "` for randomItem (not found).");
                    }
                    byte[] bytes = Util.toByteArray((InputStream)inputStream);
                    constantBytesGenerator = new ConstantBytesGenerator(bytes);
                    if (inputStream == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new BenchmarkDefinitionException("Cannot load file `" + path + "` for randomItem.", (Throwable)e);
                    }
                }
                inputStream.close();
            }
            return constantBytesGenerator;
        });
        return this;
    }

    public HttpRequestStepBuilder endBody() {
        return this.parent;
    }
}

