/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.statistics;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.hyperfoil.api.statistics.Statistics;
import io.hyperfoil.api.statistics.StatisticsSnapshot;
import io.hyperfoil.api.statistics.StatisticsSummary;
import io.hyperfoil.api.statistics.StatsExtension;

@JsonTypeName(value="http")
public class HttpStats
implements StatsExtension {
    public static final String HTTP = "http";
    private static final Statistics.LongUpdater<HttpStats> ADD_STATUS = (s, value) -> {
        switch ((int)value / 100) {
            case 2: {
                ++s.status_2xx;
                break;
            }
            case 3: {
                ++s.status_3xx;
                break;
            }
            case 4: {
                ++s.status_4xx;
                break;
            }
            case 5: {
                ++s.status_5xx;
                break;
            }
            default: {
                ++s.status_other;
            }
        }
    };
    private static final Statistics.LongUpdater<HttpStats> ADD_CACHE_HIT = (s, ignored) -> ++s.cacheHits;
    private static final String[] HEADERS = new String[]{"2xx", "3xx", "4xx", "5xx", "OtherStatus", "CacheHits"};
    public int status_2xx;
    public int status_3xx;
    public int status_4xx;
    public int status_5xx;
    public int status_other;
    public int cacheHits;

    public static void addStatus(Statistics statistics, long timestamp, int status) {
        statistics.update(HTTP, timestamp, HttpStats::new, ADD_STATUS, (long)status);
    }

    public static void addCacheHit(Statistics statistics, long timestamp) {
        statistics.update(HTTP, timestamp, HttpStats::new, ADD_CACHE_HIT, 1L);
    }

    public static HttpStats get(StatisticsSnapshot snapshot) {
        StatsExtension stats = (StatsExtension)snapshot.extensions.get(HTTP);
        if (stats == null) {
            return new HttpStats();
        }
        return (HttpStats)stats;
    }

    public static HttpStats get(StatisticsSummary summary) {
        StatsExtension stats = (StatsExtension)summary.extensions.get(HTTP);
        if (stats == null) {
            return new HttpStats();
        }
        return (HttpStats)stats;
    }

    public int[] statuses() {
        return new int[]{this.status_2xx, this.status_3xx, this.status_4xx, this.status_5xx, this.status_other};
    }

    public void reset() {
        this.status_2xx = 0;
        this.status_3xx = 0;
        this.status_4xx = 0;
        this.status_5xx = 0;
        this.status_other = 0;
        this.cacheHits = 0;
    }

    public HttpStats clone() {
        HttpStats copy = new HttpStats();
        copy.add(this);
        return copy;
    }

    public String[] headers() {
        return HEADERS;
    }

    public String byHeader(String header) {
        switch (header) {
            case "2xx": {
                return String.valueOf(this.status_2xx);
            }
            case "3xx": {
                return String.valueOf(this.status_3xx);
            }
            case "4xx": {
                return String.valueOf(this.status_4xx);
            }
            case "5xx": {
                return String.valueOf(this.status_5xx);
            }
            case "OtherStatus": {
                return String.valueOf(this.status_other);
            }
            case "CacheHits": {
                return String.valueOf(this.cacheHits);
            }
        }
        return "<unknown header: " + header + ">";
    }

    public boolean isNull() {
        return this.status_2xx + this.status_3xx + this.status_4xx + this.status_5xx + this.status_other + this.cacheHits == 0;
    }

    public void add(StatsExtension other) {
        if (other instanceof HttpStats) {
            HttpStats o = (HttpStats)other;
            this.status_2xx += o.status_2xx;
            this.status_3xx += o.status_3xx;
            this.status_4xx += o.status_4xx;
            this.status_5xx += o.status_5xx;
            this.status_other += o.status_other;
            this.cacheHits += o.cacheHits;
        } else {
            throw new IllegalArgumentException(other.toString());
        }
    }

    public void subtract(StatsExtension other) {
        if (other instanceof HttpStats) {
            HttpStats o = (HttpStats)other;
            this.status_2xx -= o.status_2xx;
            this.status_3xx -= o.status_3xx;
            this.status_4xx -= o.status_4xx;
            this.status_5xx -= o.status_5xx;
            this.status_other -= o.status_other;
            this.cacheHits -= o.cacheHits;
        } else {
            throw new IllegalArgumentException(other.toString());
        }
    }

    public String toString() {
        return "{, status_2xx=" + this.status_2xx + ", status_3xx=" + this.status_3xx + ", status_4xx=" + this.status_4xx + ", status_5xx=" + this.status_5xx + ", status_other=" + this.status_other + ", cacheHits=" + this.cacheHits + "}";
    }
}

