/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.parser;

import io.hyperfoil.api.config.BenchmarkBuilder;
import io.hyperfoil.core.parser.AbstractParser;
import io.hyperfoil.core.parser.Context;
import io.hyperfoil.core.parser.Parser;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.core.parser.PropertyParser;
import io.hyperfoil.core.parser.ReflectionParser;
import io.hyperfoil.http.config.ConnectionStrategy;
import io.hyperfoil.http.config.HttpBuilder;
import io.hyperfoil.http.config.HttpPluginBuilder;
import io.hyperfoil.http.config.Protocol;
import io.hyperfoil.http.parser.ConnectionPoolConfigParser;
import org.yaml.snakeyaml.events.ScalarEvent;
import org.yaml.snakeyaml.events.SequenceStartEvent;

public class HttpParser
extends AbstractParser<BenchmarkBuilder, HttpBuilder> {
    private static final AddressParser ADDRESS_PARSER = new AddressParser();

    public HttpParser() {
        this.register("name", (Parser)new PropertyParser.String(HttpBuilder::name));
        this.register("protocol", (Parser)new PropertyParser.String((builder, scheme) -> builder.protocol(Protocol.fromScheme(scheme))));
        this.register("host", (Parser)new PropertyParser.String(HttpBuilder::host));
        this.register("port", (Parser)new PropertyParser.Int(HttpBuilder::port));
        this.register("allowHttp1x", (Parser)new PropertyParser.Boolean(HttpBuilder::allowHttp1x));
        this.register("allowHttp2", (Parser)new PropertyParser.Boolean(HttpBuilder::allowHttp2));
        this.register("maxHttp2Streams", (Parser)new PropertyParser.Int(HttpBuilder::maxHttp2Streams));
        this.register("sharedConnections", (Parser)new ConnectionPoolConfigParser());
        this.register("pipeliningLimit", (Parser)new PropertyParser.Int(HttpBuilder::pipeliningLimit));
        this.register("directHttp2", (Parser)new PropertyParser.Boolean(HttpBuilder::directHttp2));
        this.register("requestTimeout", (Parser)new PropertyParser.String(HttpBuilder::requestTimeout));
        this.register("sslHandshakeTimeout", (Parser)new PropertyParser.String(HttpBuilder::sslHandshakeTimeout));
        this.register("addresses", HttpParser::parseAddresses);
        this.register("rawBytesHandlers", (Parser)new PropertyParser.Boolean(HttpBuilder::rawBytesHandlers));
        this.register("keyManager", (Parser)new ReflectionParser(HttpBuilder::keyManager));
        this.register("trustManager", (Parser)new ReflectionParser(HttpBuilder::trustManager));
        this.register("connectionStrategy", (Parser)new PropertyParser.Enum((Enum[])ConnectionStrategy.values(), HttpBuilder::connectionStrategy));
        this.register("useHttpCache", (Parser)new PropertyParser.Boolean(HttpBuilder::useHttpCache));
    }

    public void parse(Context ctx, BenchmarkBuilder target) throws ParserException {
        HttpPluginBuilder plugin = (HttpPluginBuilder)target.addPlugin(HttpPluginBuilder::new);
        if (ctx.peek() instanceof SequenceStartEvent) {
            ctx.parseList((Object)plugin, (ctx1, builder) -> {
                HttpBuilder http = builder.decoupledHttp();
                this.callSubBuilders(ctx1, http);
                builder.addHttp(http);
            });
        } else {
            this.callSubBuilders(ctx, plugin.http());
        }
    }

    private static void parseAddresses(Context ctx, HttpBuilder builder) throws ParserException {
        if (ctx.peek() instanceof ScalarEvent) {
            String value = ((ScalarEvent)ctx.expectEvent(ScalarEvent.class)).getValue();
            if (value != null && !value.isEmpty()) {
                builder.addAddress(value);
            }
        } else {
            ctx.parseList((Object)builder, (Parser)ADDRESS_PARSER);
        }
    }

    private static class AddressParser
    implements Parser<HttpBuilder> {
        private AddressParser() {
        }

        public void parse(Context ctx, HttpBuilder target) throws ParserException {
            ScalarEvent event = (ScalarEvent)ctx.expectEvent(ScalarEvent.class);
            target.addAddress(event.getValue());
        }
    }
}

