/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.parser;

import io.hyperfoil.core.parser.AbstractParser;
import io.hyperfoil.core.parser.Context;
import io.hyperfoil.core.parser.Parser;
import io.hyperfoil.core.parser.ParserException;
import io.hyperfoil.core.parser.PropertyParser;
import io.hyperfoil.http.config.ConnectionPoolConfig;
import io.hyperfoil.http.config.HttpBuilder;
import org.yaml.snakeyaml.events.Event;
import org.yaml.snakeyaml.events.MappingStartEvent;
import org.yaml.snakeyaml.events.ScalarEvent;

public class ConnectionPoolConfigParser
extends AbstractParser<HttpBuilder, ConnectionPoolConfig.Builder> {
    public ConnectionPoolConfigParser() {
        this.register("core", (Parser)new PropertyParser.Int(ConnectionPoolConfig.Builder::core));
        this.register("max", (Parser)new PropertyParser.Int(ConnectionPoolConfig.Builder::max));
        this.register("buffer", (Parser)new PropertyParser.Int(ConnectionPoolConfig.Builder::buffer));
        this.register("keepAliveTime", (Parser)new PropertyParser.TimeMillis(ConnectionPoolConfig.Builder::keepAliveTime));
    }

    public void parse(Context ctx, HttpBuilder http) throws ParserException {
        Event event = ctx.peek();
        if (event instanceof ScalarEvent) {
            String value = ((ScalarEvent)event).getValue();
            try {
                http.sharedConnections(Integer.parseInt(value));
            }
            catch (NumberFormatException e) {
                throw new ParserException(event, "Failed to parse as integer: " + value);
            }
            ctx.consumePeeked(event);
        } else if (event instanceof MappingStartEvent) {
            this.callSubBuilders(ctx, http.sharedConnections());
        } else {
            throw ctx.unexpectedEvent(event);
        }
    }
}

