/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.html;

import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.ObjectAccess;
import io.hyperfoil.api.session.ResourceUtilizer;
import io.hyperfoil.api.session.SequenceInstance;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.data.LimitedPoolResource;
import io.hyperfoil.core.data.Queue;
import io.hyperfoil.core.session.ObjectVar;
import io.hyperfoil.function.SerializableFunction;
import io.hyperfoil.http.api.HttpMethod;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.handlers.Redirect;
import io.hyperfoil.impl.Util;
import io.netty.buffer.ByteBuf;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class RefreshHandler
implements Processor,
ResourceUtilizer {
    private static final Logger log = LogManager.getLogger(RefreshHandler.class);
    private static final byte[] URL = "url".getBytes(StandardCharsets.UTF_8);
    private final Queue.Key immediateQueueKey;
    private final Queue.Key delayedQueueKey;
    private final LimitedPoolResource.Key<Redirect.Coords> poolKey;
    private final int concurrency;
    private final ObjectAccess immediateQueueVar;
    private final ObjectAccess delayedQueueVar;
    private final String redirectSequence;
    private final String delaySequence;
    private final ObjectAccess tempCoordsVar;
    private final SerializableFunction<Session, SequenceInstance> originalSequenceSupplier;

    public RefreshHandler(Queue.Key immediateQueueKey, Queue.Key delayedQueueKey, LimitedPoolResource.Key<Redirect.Coords> poolKey, int concurrency, ObjectAccess immediateQueueVar, ObjectAccess delayedQueueVar, String redirectSequence, String delaySequence, ObjectAccess tempCoordsVar, SerializableFunction<Session, SequenceInstance> originalSequenceSupplier) {
        this.immediateQueueKey = immediateQueueKey;
        this.delayedQueueKey = delayedQueueKey;
        this.poolKey = poolKey;
        this.concurrency = concurrency;
        this.immediateQueueVar = immediateQueueVar;
        this.delayedQueueVar = delayedQueueVar;
        this.redirectSequence = redirectSequence;
        this.delaySequence = delaySequence;
        this.tempCoordsVar = tempCoordsVar;
        this.originalSequenceSupplier = originalSequenceSupplier;
    }

    public void before(Session session) {
        this.tempCoordsVar.unset(session);
    }

    public void process(Session session, ByteBuf data, int offset, int length, boolean isLastPart) {
        assert (isLastPart);
        HttpRequest request = HttpRequest.ensure(session.currentRequest());
        if (request == null) {
            return;
        }
        try {
            long seconds = 0L;
            String url = null;
            for (int i = 0; i < length; ++i) {
                if (data.getByte(offset + i) != 59) continue;
                seconds = Util.parseLong((ByteBuf)data, (int)offset, (int)i);
                ++i;
                while (Character.isWhitespace(data.getByte(offset + i))) {
                    ++i;
                }
                while (length > 0 && Character.isWhitespace(data.getByte(offset + length - 1))) {
                    --length;
                }
                int j = 0;
                while (j < URL.length) {
                    if (Util.toLowerCase((byte)data.getByte(offset + i)) != URL[j]) {
                        log.warn("#{} Failed to parse META refresh content (missing URL): {}", (Object)session.uniqueId(), (Object)Util.toString((ByteBuf)data, (int)offset, (int)length));
                        return;
                    }
                    ++j;
                    ++i;
                }
                while (Character.isWhitespace(data.getByte(offset + i))) {
                    ++i;
                }
                if (data.getByte(offset + i) != 61) {
                    log.warn("#{} Failed to parse META refresh content (missing = after URL): {}", (Object)session.uniqueId(), (Object)Util.toString((ByteBuf)data, (int)offset, (int)length));
                    return;
                }
                ++i;
                while (Character.isWhitespace(data.getByte(offset + i))) {
                    ++i;
                }
                url = Util.toString((ByteBuf)data, (int)(offset + i), (int)(length - i));
                break;
            }
            if (url == null) {
                seconds = Util.parseLong((ByteBuf)data, (int)offset, (int)length);
            }
            Redirect.Coords coords = (Redirect.Coords)((LimitedPoolResource)session.getResource(this.poolKey)).acquire();
            coords.method = HttpMethod.GET;
            coords.originalSequence = (SequenceInstance)this.originalSequenceSupplier.apply((Object)session);
            coords.delay = (int)seconds;
            if (url == null) {
                coords.authority = request.authority;
                coords.path = request.path;
            } else if (url.startsWith("http://") || url.startsWith("https://")) {
                coords.authority = null;
                coords.path = url;
            } else {
                coords.authority = request.authority;
                if (url.startsWith("/")) {
                    coords.path = url;
                } else {
                    int lastSlash = request.path.lastIndexOf(47);
                    if (lastSlash < 0) {
                        log.warn("#{} Did the request have a relative path? {}", (Object)session.uniqueId(), (Object)request.path);
                        coords.path = "/" + url;
                    } else {
                        coords.path = request.path.substring(0, lastSlash + 1) + url;
                    }
                }
            }
            ((Queue)session.getResource((Session.ResourceKey)(seconds == 0L ? this.immediateQueueKey : this.delayedQueueKey))).push(session, (Object)coords);
            this.tempCoordsVar.setObject(session, (Object)coords);
        }
        catch (NumberFormatException e) {
            log.warn("#{} Failed to parse META refresh content: {}", (Object)session.uniqueId(), (Object)Util.toString((ByteBuf)data, (int)offset, (int)length));
        }
    }

    public void reserve(Session session) {
        session.declareResource(this.poolKey, () -> LimitedPoolResource.create((int)this.concurrency, Redirect.Coords.class, Redirect.Coords::new), true);
        session.declareResource((Session.ResourceKey)this.immediateQueueKey, () -> new Queue(this.immediateQueueVar, this.concurrency, this.concurrency, this.redirectSequence, null), true);
        session.declareResource((Session.ResourceKey)this.delayedQueueKey, () -> new Queue(this.delayedQueueVar, this.concurrency, this.concurrency, this.delaySequence, null), true);
        this.initQueueVar(session, this.immediateQueueVar);
        this.initQueueVar(session, this.delayedQueueVar);
    }

    private void initQueueVar(Session session, ObjectAccess var) {
        if (!var.isSet(session)) {
            var.setObject(session, (Object)ObjectVar.newArray((Session)session, (int)this.concurrency));
        }
    }
}

