/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.html;

import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.http.HttpUtil;
import io.hyperfoil.http.api.HttpDestinationTable;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.html.FetchResourceHandler;
import io.hyperfoil.impl.Util;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.util.internal.AppendableCharSequence;
import java.nio.charset.StandardCharsets;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class EmbeddedResourceProcessor
extends Processor.BaseDelegating {
    private static final Logger log = LogManager.getLogger(EmbeddedResourceProcessor.class);
    private static final boolean trace = log.isTraceEnabled();
    private static final byte[] HTTP_PREFIX = "http://".getBytes(StandardCharsets.UTF_8);
    private static final byte[] HTTPS_PREFIX = "http://".getBytes(StandardCharsets.UTF_8);
    private final boolean ignoreExternal;
    private final FetchResourceHandler fetchResource;

    EmbeddedResourceProcessor(boolean ignoreExternal, Processor delegate, FetchResourceHandler fetchResource) {
        super(delegate);
        this.ignoreExternal = ignoreExternal;
        this.fetchResource = fetchResource;
    }

    public void before(Session session) {
        if (this.fetchResource != null) {
            this.fetchResource.before(session);
        }
        if (this.delegate != null) {
            super.before(session);
        }
    }

    public void after(Session session) {
        if (this.delegate != null) {
            super.after(session);
        }
        if (this.fetchResource != null) {
            this.fetchResource.after(session);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process(Session session, ByteBuf data, int offset, int length, boolean isLastPart) {
        assert (isLastPart);
        HttpRequest request = HttpRequest.ensure(session.currentRequest());
        if (request == null) {
            return;
        }
        boolean isHttp = Util.hasPrefix((ByteBuf)data, (int)offset, (int)length, (byte[])HTTP_PREFIX);
        boolean isHttps = Util.hasPrefix((ByteBuf)data, (int)offset, (int)length, (byte[])HTTPS_PREFIX);
        if (isHttp || isHttps) {
            String authority = null;
            HttpDestinationTable destinations = HttpDestinationTable.get(session);
            byte[][] authorityBytes = destinations.authorityBytes();
            for (int i = 0; i < authorityBytes.length; ++i) {
                if (!HttpUtil.authorityMatch(data, offset, length, authorityBytes[i], isHttp)) continue;
                authority = destinations.authorities()[i];
                break;
            }
            if (authority == null && this.ignoreExternal) {
                if (trace) {
                    log.trace("#{} Ignoring external URL {}", (Object)session.uniqueId(), (Object)Util.toString((ByteBuf)data, (int)offset, (int)length));
                }
                return;
            }
            if (trace) {
                log.trace("#{} Matched URL {}", (Object)session.uniqueId(), (Object)Util.toString((ByteBuf)data, (int)offset, (int)length));
            }
            if (this.fetchResource != null) {
                int pathStart = data.indexOf(offset + (isHttp ? HTTP_PREFIX.length : HTTPS_PREFIX.length), offset + length, (byte)47);
                String path = pathStart < 0 ? "/" : data.toString(pathStart, offset + length - pathStart, StandardCharsets.UTF_8);
                this.fetchResource.handle(session, authority, path);
            }
            if (this.delegate != null) {
                this.delegate.process(session, data, offset, length, true);
            }
        } else if (data.getByte(offset) == 47) {
            if (trace) {
                log.trace("#{} Matched URL {}", (Object)session.uniqueId(), (Object)Util.toString((ByteBuf)data, (int)offset, (int)length));
            }
            if (this.fetchResource != null) {
                this.fetchResource.handle(session, request.authority, data.toString(offset, length, StandardCharsets.UTF_8));
            }
            if (this.delegate != null) {
                this.delegate.process(session, data, offset, length, true);
            }
        } else {
            if (trace) {
                log.trace("#{} Matched URL {}", (Object)session.uniqueId(), (Object)Util.toString((ByteBuf)data, (int)offset, (int)length));
            }
            if (this.fetchResource != null) {
                AppendableCharSequence newPath = new AppendableCharSequence(request.path.length() + length);
                int end = request.path.lastIndexOf(47);
                if (end < 0) {
                    newPath.append((CharSequence)request.path).append('/');
                } else {
                    newPath.append((CharSequence)request.path, 0, end + 1);
                }
                newPath.append((CharSequence)Util.toString((ByteBuf)data, (int)offset, (int)length));
                if (trace) {
                    log.trace("#{} Rewritten relative URL to {}", (Object)session.uniqueId(), (Object)newPath);
                }
                this.fetchResource.handle(session, request.authority, (CharSequence)newPath);
            }
            if (this.delegate != null) {
                ByteBuf buffer = ByteBufAllocator.DEFAULT.buffer(request.path.length() + length);
                try {
                    Util.string2byteBuf((CharSequence)request.path, (ByteBuf)buffer);
                    for (int i = buffer.writerIndex() - 1; i >= 0; --i) {
                        if (buffer.getByte(i) != 47) continue;
                        buffer.writerIndex(i + 1);
                        break;
                    }
                    buffer.ensureWritable(length);
                    buffer.writeBytes(data, offset, length);
                    if (trace) {
                        log.trace("#{} Rewritten relative URL to {}", (Object)session.uniqueId(), (Object)Util.toString((ByteBuf)buffer, (int)buffer.readerIndex(), (int)buffer.readableBytes()));
                    }
                    this.delegate.process(session, buffer, buffer.readerIndex(), buffer.readableBytes(), true);
                }
                finally {
                    buffer.release();
                }
            }
        }
    }
}

