/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.html;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Embed;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.core.builders.ServiceLoadedBuilderProvider;
import io.hyperfoil.core.handlers.MultiProcessor;
import io.hyperfoil.http.html.EmbeddedResourceProcessor;
import io.hyperfoil.http.html.FetchResourceHandler;
import io.hyperfoil.http.html.HtmlHandler;

public class EmbeddedResourceHandlerBuilder
implements HtmlHandler.TagHandlerBuilder<EmbeddedResourceHandlerBuilder> {
    private static final String[] TAGS = new String[]{"img", "link", "embed", "frame", "iframe", "object", "script"};
    private static final String[] ATTRS = new String[]{"src", "href", "src", "src", "src", "data", "src"};
    private boolean ignoreExternal = true;
    private MultiProcessor.Builder<EmbeddedResourceHandlerBuilder, ?> processors = new MultiProcessor.Builder((Object)this);
    private FetchResourceHandler.Builder fetchResource;

    public EmbeddedResourceHandlerBuilder ignoreExternal(boolean ignoreExternal) {
        this.ignoreExternal = ignoreExternal;
        return this;
    }

    public FetchResourceHandler.Builder fetchResource() {
        this.fetchResource = new FetchResourceHandler.Builder();
        return this.fetchResource;
    }

    public ServiceLoadedBuilderProvider<Processor.Builder> processor() {
        return this.processors().processor();
    }

    @Embed
    public MultiProcessor.Builder<EmbeddedResourceHandlerBuilder, ?> processors() {
        return this.processors;
    }

    @Override
    public HtmlHandler.BaseTagAttributeHandler build() {
        if (this.processors.isEmpty() && this.fetchResource == null) {
            throw new BenchmarkDefinitionException("embedded resource handler must define either processor or fetchResource!");
        }
        Processor processor = this.processors.isEmpty() ? null : this.processors.build(false);
        FetchResourceHandler fetchResource = this.fetchResource != null ? this.fetchResource.build() : null;
        return new HtmlHandler.BaseTagAttributeHandler(TAGS, ATTRS, (Processor)new EmbeddedResourceProcessor(this.ignoreExternal, processor, fetchResource));
    }
}

