/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.handlers;

import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.statistics.Counters;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.StatusHandler;

public class StatusToStatsHandler
implements StatusHandler {
    private static final int FIRST_STATUS = 100;
    private static final int LAST_STATUS = 599;
    private static final String[] statusStrings = new String[500];

    @Override
    public void handleStatus(HttpRequest request, int status) {
        Object statusString = status >= 100 && status <= 599 ? statusStrings[status - 100] : "status_" + status;
        request.statistics().update("exact_status", request.startTimestampMillis(), Counters::new, Counters::increment, statusString);
    }

    static {
        for (int i = 0; i <= 499; ++i) {
            StatusToStatsHandler.statusStrings[i] = "status_" + (i + 100);
        }
    }

    @Name(value="stats")
    public static class Builder
    implements StatusHandler.Builder {
        @Override
        public StatusHandler build() {
            return new StatusToStatsHandler();
        }
    }
}

