/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.handlers;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.InitFromParam;
import io.hyperfoil.api.config.Locator;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.statistics.Statistics;
import io.hyperfoil.function.SerializableToLongFunction;
import io.hyperfoil.http.api.HeaderHandler;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.impl.Util;
import io.netty.util.AsciiString;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;

public class RecordHeaderTimeHandler
implements HeaderHandler {
    private final int stepId;
    private final String header;
    private final String statistics;
    private final SerializableToLongFunction<CharSequence> transform;
    private transient AsciiString asciiHeader;

    public RecordHeaderTimeHandler(int stepId, String header, String statistics, SerializableToLongFunction<CharSequence> transform) {
        this.stepId = stepId;
        this.header = header;
        this.statistics = statistics;
        this.transform = transform;
        this.asciiHeader = new AsciiString((CharSequence)header);
    }

    private Object readResolve() {
        this.asciiHeader = new AsciiString((CharSequence)this.header);
        return this;
    }

    @Override
    public void handleHeader(HttpRequest request, CharSequence header, CharSequence value) {
        if (!this.asciiHeader.contentEqualsIgnoreCase(header)) {
            return;
        }
        long longValue = this.transform.applyAsLong((Object)value);
        if (longValue < 0L) {
            return;
        }
        Statistics statistics = request.session.statistics(this.stepId, this.statistics);
        statistics.incrementRequests(request.startTimestampMillis());
        statistics.recordResponse(request.startTimestampMillis(), longValue);
    }

    @Name(value="recordHeaderTime")
    public static class Builder
    implements HeaderHandler.Builder,
    InitFromParam<Builder> {
        private String header;
        private String metric;
        private String unit;

        public Builder init(String param) {
            this.header = param;
            return this;
        }

        @Override
        public RecordHeaderTimeHandler build() {
            if (this.header == null || this.header.isEmpty()) {
                throw new BenchmarkDefinitionException("Must define the header.");
            }
            if (this.header.chars().anyMatch(c -> c > 255)) {
                throw new BenchmarkDefinitionException("Header contains non-ASCII characters.");
            }
            if (this.metric == null) {
                this.metric = this.header;
            }
            SerializableToLongFunction & Serializable transform = Util::parseLong;
            if (this.unit != null) {
                switch (this.unit) {
                    case "ms": {
                        transform = (SerializableToLongFunction & Serializable)value -> TimeUnit.MILLISECONDS.toNanos(Util.parseLong((CharSequence)value));
                        break;
                    }
                    case "ns": {
                        break;
                    }
                    default: {
                        throw new BenchmarkDefinitionException("Unknown unit '" + this.unit + "'");
                    }
                }
            }
            return new RecordHeaderTimeHandler(Locator.current().step().id(), this.header, this.metric, (SerializableToLongFunction<CharSequence>)transform);
        }

        public Builder header(String header) {
            this.header = header;
            return this;
        }

        public Builder metric(String metric) {
            this.metric = metric;
            return this;
        }

        public Builder unit(String unit) {
            this.unit = unit;
            return this;
        }
    }
}

