/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.handlers;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.PartialBuilder;
import io.hyperfoil.core.builders.ServiceLoadedBuilderProvider;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.StatusHandler;
import io.hyperfoil.http.handlers.BaseRangeStatusHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiplexStatusHandler
extends BaseRangeStatusHandler {
    private final StatusHandler[][] handlers;
    private final StatusHandler[] other;

    public MultiplexStatusHandler(int[] ranges, StatusHandler[][] handlers, StatusHandler[] other) {
        super(ranges);
        this.handlers = handlers;
        this.other = other;
    }

    @Override
    protected void onStatusRange(HttpRequest request, int status, int index) {
        for (StatusHandler h : this.handlers[index]) {
            h.handleStatus(request, status);
        }
    }

    @Override
    protected void onOtherStatus(HttpRequest request, int status) {
        if (this.other != null) {
            for (StatusHandler h : this.other) {
                h.handleStatus(request, status);
            }
        }
    }

    @Name(value="multiplex")
    public static class Builder
    implements StatusHandler.Builder,
    PartialBuilder {
        private final Map<String, List<StatusHandler.Builder>> handlers = new HashMap<String, List<StatusHandler.Builder>>();

        public ServiceLoadedBuilderProvider<StatusHandler.Builder> withKey(String range) {
            ArrayList<StatusHandler.Builder> handlers = new ArrayList<StatusHandler.Builder>();
            this.add(range, handlers);
            return new ServiceLoadedBuilderProvider(StatusHandler.Builder.class, handlers::add);
        }

        public Builder add(String range, List<StatusHandler.Builder> handlers) {
            if (this.handlers.putIfAbsent(range, handlers) != null) {
                throw new BenchmarkDefinitionException("Range '" + range + "' is already set.");
            }
            return this;
        }

        @Override
        public MultiplexStatusHandler build() {
            ArrayList<Integer> ranges = new ArrayList<Integer>();
            ArrayList handlers = new ArrayList();
            StatusHandler[] other = BaseRangeStatusHandler.checkAndSortRanges(this.handlers, ranges, handlers, list -> (StatusHandler[])list.stream().map(StatusHandler.Builder::build).toArray(StatusHandler[]::new));
            return new MultiplexStatusHandler(ranges.stream().mapToInt(Integer::intValue).toArray(), (StatusHandler[][])handlers.toArray((T[])new StatusHandler[0][]), other);
        }
    }
}

