/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.handlers;

import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.connection.Request;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.http.api.HeaderHandler;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.impl.Util;
import io.netty.buffer.ByteBuf;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogInvalidHandler
implements Processor,
HeaderHandler {
    private static final Logger log = LogManager.getLogger(LogInvalidHandler.class);

    public void process(Session session, ByteBuf data, int offset, int length, boolean isLast) {
        Request request = session.currentRequest();
        if (request != null && !request.isValid()) {
            if (request instanceof HttpRequest) {
                HttpRequest httpRequest = (HttpRequest)request;
                log.debug("#{}: {} {}/{}, {} bytes: {}", (Object)session.uniqueId(), (Object)httpRequest.method, (Object)httpRequest.authority, (Object)httpRequest.path, (Object)data.readableBytes(), (Object)Util.toString((ByteBuf)data, (int)data.readerIndex(), (int)data.readableBytes()));
            } else {
                log.debug("#{}: {} bytes: {}", (Object)session.uniqueId(), (Object)data.readableBytes(), (Object)Util.toString((ByteBuf)data, (int)data.readerIndex(), (int)data.readableBytes()));
            }
        }
    }

    @Override
    public void handleHeader(HttpRequest request, CharSequence header, CharSequence value) {
        if (!request.isValid()) {
            log.debug("#{}: {} {}/{}, {}: {}", (Object)request.session.uniqueId(), (Object)request.method, (Object)request.authority, (Object)request.path, (Object)header, (Object)value);
        }
    }

    @Name(value="logInvalid")
    public static class HeaderHandlerBuilder
    implements HeaderHandler.Builder {
        @Override
        public LogInvalidHandler build() {
            return new LogInvalidHandler();
        }
    }

    @Name(value="logInvalid")
    public static class BodyHandlerBuilder
    implements Processor.Builder {
        public LogInvalidHandler build(boolean fragmented) {
            return new LogInvalidHandler();
        }
    }
}

