/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.handlers;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Embed;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.processor.Processor;
import io.hyperfoil.api.session.Session;
import io.hyperfoil.core.builders.StringConditionBuilder;
import io.hyperfoil.core.handlers.MultiProcessor;
import io.hyperfoil.function.SerializableBiPredicate;
import io.hyperfoil.http.api.HeaderHandler;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.impl.Util;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;

public class FilterHeaderHandler
implements HeaderHandler {
    private final SerializableBiPredicate<Session, CharSequence> header;
    private final Processor processor;

    public FilterHeaderHandler(SerializableBiPredicate<Session, CharSequence> header, Processor processor) {
        this.header = header;
        this.processor = processor;
    }

    @Override
    public void beforeHeaders(HttpRequest request) {
        this.processor.before(request.session);
    }

    @Override
    public void afterHeaders(HttpRequest request) {
        this.processor.after(request.session);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleHeader(HttpRequest request, CharSequence header, CharSequence value) {
        if (this.header.test((Object)request.session, (Object)header)) {
            if (value == null || value.length() == 0) {
                this.processor.process(request.session, Unpooled.EMPTY_BUFFER, 0, 0, true);
            } else {
                ByteBuf byteBuf = Util.string2byteBuf((CharSequence)value, (ByteBuf)request.connection().context().alloc().buffer());
                try {
                    this.processor.process(request.session, byteBuf, byteBuf.readerIndex(), byteBuf.readableBytes(), true);
                }
                finally {
                    byteBuf.release();
                }
            }
        }
    }

    @Name(value="filter")
    public static class Builder
    implements HeaderHandler.Builder {
        private StringConditionBuilder<?, Builder> header = new StringConditionBuilder((Object)this).caseSensitive(false);
        @Embed
        public MultiProcessor.Builder<Builder, ?> processors = new MultiProcessor.Builder((Object)this);

        @Override
        public FilterHeaderHandler build() {
            if (this.processors.isEmpty()) {
                throw new BenchmarkDefinitionException("Processor was not set!");
            }
            Processor processor = this.processors.buildSingle(false);
            return new FilterHeaderHandler((SerializableBiPredicate<Session, CharSequence>)this.header.buildPredicate(), processor);
        }

        public StringConditionBuilder<?, Builder> header() {
            return this.header;
        }

        public Builder processor(Processor.Builder processor) {
            this.processors.processor(processor);
            return this;
        }
    }
}

