/*
 * Decompiled with CFR 0.152.
 */
package io.hyperfoil.http.handlers;

import io.hyperfoil.api.config.BenchmarkDefinitionException;
import io.hyperfoil.api.config.Name;
import io.hyperfoil.api.config.PartialBuilder;
import io.hyperfoil.api.session.Action;
import io.hyperfoil.core.builders.ServiceLoadedBuilderProvider;
import io.hyperfoil.http.api.HttpRequest;
import io.hyperfoil.http.api.StatusHandler;
import io.hyperfoil.http.handlers.BaseRangeStatusHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ActionStatusHandler
extends BaseRangeStatusHandler {
    private final Action[][] actions;
    private final Action[] otherActions;

    public ActionStatusHandler(int[] statusRanges, Action[][] actions, Action[] otherActions) {
        super(statusRanges);
        assert (statusRanges.length == 2 * actions.length);
        this.actions = actions;
        this.otherActions = otherActions;
    }

    @Override
    protected void onStatusRange(HttpRequest request, int status, int index) {
        for (Action a : this.actions[index]) {
            a.run(request.session);
        }
    }

    @Override
    protected void onOtherStatus(HttpRequest request, int status) {
        if (this.otherActions != null) {
            for (Action a : this.otherActions) {
                a.run(request.session);
            }
        }
    }

    @Name(value="action")
    public static class Builder
    implements StatusHandler.Builder,
    PartialBuilder {
        private Map<String, List<Action.Builder>> actions = new HashMap<String, List<Action.Builder>>();

        public ServiceLoadedBuilderProvider<Action.Builder> withKey(String range) {
            ArrayList<Action.Builder> actions = new ArrayList<Action.Builder>();
            this.add(range, actions);
            return new ServiceLoadedBuilderProvider(Action.Builder.class, actions::add);
        }

        public Builder add(String range, List<Action.Builder> actions) {
            if (this.actions.putIfAbsent(range, actions) != null) {
                throw new BenchmarkDefinitionException("Range '" + range + "' is already set.");
            }
            return this;
        }

        @Override
        public ActionStatusHandler build() {
            ArrayList<Integer> ranges = new ArrayList<Integer>();
            ArrayList actions = new ArrayList();
            Action[] otherActions = BaseRangeStatusHandler.checkAndSortRanges(this.actions, ranges, actions, list -> (Action[])list.stream().map(Action.Builder::build).toArray(Action[]::new));
            return new ActionStatusHandler(ranges.stream().mapToInt(Integer::intValue).toArray(), (Action[][])actions.toArray((T[])new Action[0][]), otherActions);
        }
    }
}

